package com.bxm.openlog.sdk.listener;

import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.warcar.mq.ConsumeStatus;

/**
 * 日志订阅者
 *
 * @author allen
 * @date 2021-09-30
 * @since 1.0
 */
public interface LogSubscriber {

    /**
     * 返回订阅者ID，在相同的 production 和 mt 中必须保持唯一。
     * @return ID
     */
    String getId();

    /**
     * 返回订阅的产品线
     * @return 业务产品
     */
    Production getProduction();

    /**
     * 返回订阅的行为类型列表
     * @return mts
     */
    String[] getMts();

    /**
     * 消费日志
     * @param keyValueMap 日志
     * @return 消费状态
     */
    ConsumeStatus consume(KeyValueMap keyValueMap);
}
