package com.bxm.openlog.sdk.listener.eventbus;

import org.springframework.context.annotation.Import;

import java.lang.annotation.*;

/**
 * <p>注解表示开启 OpenLog EventBus （事件总线） 功能。</p>
 * <p>标记注解后还需要创建 {@link OpenLogEventBusBean} 来定义哪些产品线需要使用事件总线。</p>
 * <p>基于 EventBus 的实现，同一个产品线可以只需要创建一个消费者，然后这个消费者负责将不同的行为类型发送不同的事件，来完成业务目标。</p>
 * <p>但是它的消息是不能重复消费的，需要业务方自行实现重试逻辑。</p>
 *
 * @author allen
 * @date 2022-01-21
 * @since 1.0
 * @see com.bxm.openlog.sdk.listener.EnableLogSubscriberFactory
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Import(OpenLogEventBusFactory.class)
public @interface EnableOpenLogEventBusFactory {
}
