package com.bxm.openlog.sdk.listener.eventbus;

import com.bxm.openlog.sdk.Production;
import com.bxm.warcar.integration.eventbus.EventPark;

import java.util.Collection;

/**
 * @author allen
 * @date 2022-01-21
 * @since 1.0
 */
public interface OpenLogEventBusBean {

    /**
     * 返回订阅者ID，在相同的 production 中必须保持唯一。
     * @return ID
     */
    String getId();

    /**
     * 返回订阅的产品线
     * @return 业务产品
     */
    Production getProduction();

    /**
     * 返回事件总线
     * @return EventPark
     */
    EventPark getEventPark();

    /**
     * 绑定事件
     * @param registry 事件注册器
     */
    void bindTo(Collection<OpenLogEventConfig> registry);
}
