/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.openlog.sdk.listener;

import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.Topic;
import com.bxm.openlog.sdk.listener.LogSubscriber;
import com.bxm.openlog.sdk.listener.SubscriberMessageListener;
import com.bxm.openlog.sdk.serial.Serialization;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.autoconfigure.rocketmq.RocketmqProperties;
import com.bxm.warcar.mq.rocketmq.RocketmqConsumer;
import com.bxm.warcar.utils.MapHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;

public class LogSubscriberFactory
implements BeanPostProcessor,
DisposableBean,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(LogSubscriberFactory.class);
    private final Map<String, Map<String, LogSubscriber>> subscribers = Maps.newHashMap();
    private final Map<String, Consumer> consumerMap = Maps.newHashMap();
    private final RocketmqProperties rocketmqProperties;
    private final Serialization serialization;

    public LogSubscriberFactory(RocketmqProperties rocketmqProperties, Serialization serialization) {
        this.rocketmqProperties = rocketmqProperties;
        this.serialization = serialization;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        for (Consumer consumer : this.consumerMap.values()) {
            consumer.start();
            if (!log.isInfoEnabled()) continue;
            Listener listener = consumer.getMessageListener();
            log.info("Consumer topic:{} id:{} instance:{} has been started!", new Object[]{listener.getTopic(), listener.getConsumerId(), consumer});
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!(bean instanceof LogSubscriber)) {
            return bean;
        }
        LogSubscriber logSubscriber = (LogSubscriber)bean;
        Production production = logSubscriber.getProduction();
        String id = logSubscriber.getId();
        String[] mts = logSubscriber.getMts();
        Preconditions.checkNotNull((Object)((Object)production), (Object)(bean + " production cannot be null!"));
        Preconditions.checkNotNull((Object)mts, (Object)(bean + " mts cannot be blank!"));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)(bean + " id cannot be blank!"));
        String subscriberMapKey = (Object)((Object)production) + "_" + id;
        String topic = Topic.dispatchMtLog(production.getName());
        String consumerId = ("CID_" + id + "_" + topic).toUpperCase();
        for (String mt : mts) {
            ((Map)MapHelper.get(this.subscribers, (Object)subscriberMapKey, (Object)Maps.newHashMap())).put(mt, logSubscriber);
            if (!log.isInfoEnabled()) continue;
            log.info("Registered subscriber [{}] for production: {} mt: {} on id: {}", new Object[]{subscriberMapKey, production, mt, id});
        }
        if (this.consumerMap.containsKey(consumerId)) {
            return bean;
        }
        SubscriberMessageListener listener = new SubscriberMessageListener(id, topic, consumerId, this.serialization, this.subscribers.get(subscriberMapKey));
        Consumer consumer = this.createConsumer(listener);
        this.consumerMap.put(consumerId, consumer);
        if (log.isInfoEnabled()) {
            log.info("Registered consumer {} for topic {}", (Object)consumerId, (Object)topic);
        }
        return bean;
    }

    public void destroy() {
        for (Consumer consumer : this.consumerMap.values()) {
            consumer.shutdown();
        }
    }

    private Consumer createConsumer(SingleMessageListener listener) {
        String nameSrvAddr = this.rocketmqProperties.getNameSrvAddr();
        return new RocketmqConsumer(nameSrvAddr, listener, listener.getConsumerId(), this.rocketmqProperties.getBrokerAddrAliasMap());
    }
}

