package com.bxm.adsmanager.timer;

import com.bxm.adsmanager.timer.cashcat.OfflineConfig;
import com.bxm.warcar.configure.spring.SpringBootEnvironmentListener;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ImportResource;

@SpringBootApplication
@EnableFeignClients({
		"com.bxm.adapi.facade",
		"com.bxm.profit.facade",
		"com.bxm.log.facade",
		"com.bxm.adsmanager.integration.advertiser.service",
		"com.bxm.datapark.facade",
		"com.bxm.datapark.web",
		"com.bxm.acl.facade",
		"com.bxm.adsmedia.facade",
		"com.bxm.adsmanager.integration.adsmedia",
		"com.bxm.activites.facade",
		"com.bxm.mccms.facade.service",
		"com.bxm.activities.service"
})
@EnableDiscoveryClient
@MapperScan(basePackages = "com.bxm.adsmanager.dal.mapper")
@ImportResource({ "classpath:application-domain.xml" })
@EnableConfigurationProperties(OfflineConfig.class)
public class AdsmanagerTimerApplication {
	public static void main(String[] args) {
		SpringApplication application = new SpringApplication(AdsmanagerTimerApplication.class);
		application.addListeners(new SpringBootEnvironmentListener());
		application.run(args);
	}
}
