package com.bxm.adsmanager.timer.adAssets;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import com.bxm.adsmanager.service.adkeeper.AdTicketStatService;

/**
 * @Title:AdAssetsStatJob.java
 * @Package:com.bxm.adsmanager.timer.adAssets
 * @Description: 广告素材统计类
 */
@Component
@Slf4j
public class AdAssetsStatJob {

    @Autowired
    private AdTicketStatService adTicketStatService;

    /**
     * @Title: statAdAssets
     * @Description: 统计广告素材低于预设点击率的素材信息，每天9:00和18:00
     */
    //@Scheduled(cron = "0 0 9,18 * * ?")
    public void statAdAssets() {
        try {
            adTicketStatService.addAdTicketStatData();
        } catch (Exception e) {
            log.error("统计广告素材低于预设点击率的素材信息出错" + e.getMessage(), e);
        }
    }

}
