package com.bxm.adsmanager.timer.cashcat.youmi;

import com.bxm.adsmanager.model.dao.overseas.OverseasOfflineAdvert;
import com.bxm.adsmanager.model.dto.overseas.OverseasOfflineAdSyncDto;
import com.bxm.adsmanager.model.enums.OverseasOfflineAdSourceEnum;
import com.bxm.adsmanager.model.enums.OverseasOfflineAdStatusEnum;
import com.bxm.adsmanager.model.enums.OverseasOfflinePayTypeEnum;
import com.bxm.adsmanager.timer.cashcat.OfflineAdPush;
import com.bxm.adsmanager.timer.cashcat.OfflineApiService;
import com.bxm.adsmanager.timer.cashcat.OfflineConfig;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author fgf
 * @date 2022/10/28
 **/
@Component
@Slf4j
public class YouMiService implements OfflineApiService, OfflineAdPush {
    private final RestTemplate restTemplate;
    private final OfflineConfig offlineConfig;
    private ApplicationContext applicationContext;
    public YouMiService(RestTemplate restTemplate, OfflineConfig offlineConfig) {
        this.restTemplate = restTemplate;
        this.offlineConfig = offlineConfig;
    }

    @Override
    public OverseasOfflineAdSyncDto offer(MultiValueMap<String, String> params) {
        YouMiConfig config = offlineConfig.getYouMiConfig();
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString(config.getApiUrl())
                .queryParam("app_id", config.getApp_id())
                .queryParam("page_size", config.getPage_size());
        HttpEntity<Request> requestBody = new HttpEntity(new LinkedHashMap<>());
        ResponseEntity<Response> response = restTemplate
                .exchange(builder.toUriString(), HttpMethod.GET, requestBody, Response.class);
        HttpStatus status = response.getStatusCode();
        if (!HttpStatus.OK.equals(status)) {
            return null;
        }
        Response body = response.getBody();
        OverseasOfflineAdSyncDto overseasOfflineAdSyncDto = buildAdSyncDto(body);
        return overseasOfflineAdSyncDto;
    }

    private OverseasOfflineAdSyncDto buildAdSyncDto(Response response) {
        OverseasOfflineAdSyncDto dto = OverseasOfflineAdSyncDto.builder()
                .data(buildData(response))
                .part(false)
                .build();
        return dto;
    }

    private List<OverseasOfflineAdvert> buildData(Response response) {
        List<OverseasOfflineAdvert> advertList = Lists.newArrayList();
        List<Offer> offers = response.getOffers();
        for (Offer offer : offers) {
            OverseasOfflineAdvert.OverseasOfflineAdvertBuilder builder = OverseasOfflineAdvert.builder();
            builder.appCategory(null)
                    .appDesc(null)
                    .appLabel(CollectionUtils.isEmpty(offer.getStore_label()) ? null : JsonHelper.convert(offer.getStore_label()))
                    .appName(null)
                    .appPackageName(offer.getPkg())
                    .appRate(offer.getStore_rating())
                    .appSize(StringUtils.isEmpty(offer.getSize()) ? null : Integer.valueOf(offer.getSize()))
                    .blacklist(null)
                    .conversionFlow(offer.getConversion_flow_description())
                    .createTime(null)
                    .dailyCap(offer.getCap())
                    .id(null)
                    .iconMaterial(Constants.getIcon(offer.getIcon_url()))
                    .kpi(offer.getKpi())
                    .imageMaterial(Constants.getCreative(offer.getCreative()))
                    .legalDoc(null)
                    .linkType(null)
                    .minVersion(null)
                    .modifiedTime(null)
                    .offerCategory(StringUtils.isEmpty(offer.getCategory()) ? null : JsonHelper.convert(Lists.newArrayList(offer.getCategory())))
                    .offerCountry(CollectionUtils.isEmpty(offer.getCountry()) ? JsonHelper.convert(Lists.newArrayList("ALL")) : JsonHelper.convert(offer.getCountry()))
                    .offerDesc(offer.getAdtxt())
                    .offerId(offer.getId())
                    .offerName(offer.getName())
                    .offerStatus(OverseasOfflineAdStatusEnum.USABLE.getCode())
                    .offerSource(OverseasOfflineAdSourceEnum.YOU_MI.getCode())
                    .payPrice(Objects.nonNull(offer.getPayout()) ? new BigDecimal(offer.getPayout()) : null)
                    .payType(OverseasOfflinePayTypeEnum.getEnumByCodeStr(offer.getPayout_type()).getCode())
                    .previewUrl(offer.getPreview_url())
                    .targetCarries(CollectionUtils.isEmpty(offer.getCarrier()) ? null : JsonHelper.convert(offer.getCarrier()))
                    .targetDevice(null)
                    .targetPlatform(CollectionUtils.isEmpty(offer.getOs()) ? null : JsonHelper.convert(offer.getOs()))
                    .taskDesc(Objects.nonNull(offer.getTask_description_for_user()) ? JsonHelper.convert(offer.getTask_description_for_user()) : null)
                    .trackingLink(offer.getTrackinglink())
                    .trackingLinkParameter(Constants.getTrackingLinkParameter(offer.getMandatory_device()))
                    .trafficExclude(null)
                    .trafficNetwork(null)
                    .trafficSource(Constants.getTrafficSource(offer.getTraffic(), offer.getStream_type()))
                    .videoMaterial(Constants.getVideo(offer.getVideo()))
                    .whitelist(null)
                    .videoMaterial(Constants.getVideo(offer.getVideo()))
                    .minVersion(offer.getOs_version())
            ;
            advertList.add(builder.build());
        }
        return advertList;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void pushOfflineAd(MultiValueMap<String, String> params) {
        OverseasOfflineAdSyncDto overseasOfflineAdSyncDto = offer(params);
        if (Objects.nonNull(overseasOfflineAdSyncDto)) {
            applicationContext.publishEvent(overseasOfflineAdSyncDto);
        }
    }
}
