package com.bxm.adsmanager.timer.conf;

import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;


/**
 * @author allen
 * @since 1.0.0
 */
@Configuration
@EnableConfigurationProperties(NewRedisConfiguration.class)
public class NewFMRedisConfiguration {

    private final NewRedisConfiguration newRedisConfiguration;

    public NewFMRedisConfiguration(NewRedisConfiguration newRedisConfiguration) {
        this.newRedisConfiguration = newRedisConfiguration;
    }

    @Bean
    public JedisPool jedisPoolForFM() {
        return new JedisPool(newRedisConfiguration, newRedisConfiguration.getHost(), newRedisConfiguration.getPort(), newRedisConfiguration.getTimeout(),
                newRedisConfiguration.getPassword(), newRedisConfiguration.getDatabase());
    }

    @Bean
    public JedisFetcher jedisFetcherForFM() {
        return new JedisFetcher(jedisPoolForFM());
    }

    @Bean
    public JedisCounter jedisCounterForFM() {
        return new JedisCounter(jedisPoolForFM());
    }

    @Bean
    public JedisUpdater jedisUpdaterForFM() {
        return new JedisUpdater(jedisPoolForFM());
    }

}

