package com.bxm.adsmanager.timer.exception;

import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * 全局异常处理类
 */
@RestControllerAdvice
@Slf4j
public class GlobalExceptionController {

    /**
     * 异常
     */
    @ExceptionHandler(value = Exception.class)
    public ResultModel exception(Exception v) {
        log.error("捕获到异常" + v.getMessage(),v);
        return ResultModelFactory.FAILED500(v.getMessage());
    }


    /**
     * 运行时异常
     */
    @ExceptionHandler(value = RuntimeException.class)
    public ResultModel runtimeException(RuntimeException v) {
        log.error("捕获到异常" + v.getMessage(),v);
        return ResultModelFactory.FAILED500(v.getMessage());
    }

}
