package com.bxm.adsmanager.timer.kuaishou;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.integration.getui.utils.HttpUtils;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.vo.kuaishou.KuaishouAuthResponse;
import com.bxm.adsmanager.model.vo.kuaishou.KuaishouTokenVo;
import com.bxm.adsmanager.model.vo.weibo.WBToken;
import com.bxm.util.DateUtil;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.*;


/**
 * 快手刷新token调度
 * @author :tangxiao
 */
@Slf4j
@Component
public class KuaishouJob {


    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    @Autowired
    private JedisFetcher fetcher;

    @Autowired
    @Qualifier("rtbJedisUpdater")
    private JedisUpdater rtbJedisUpdater;


    private static final String refreshUrl = "https://ad.e.kuaishou.com/rest/openapi/oauth2/authorize/refresh_token";

    /**
     * @Title:
     * @Description: 快手的定时刷新接口
     * @author 唐骁
     * @date 2022年11月16日
     */
    public void execute() {
        Map<String, KuaishouTokenVo> map = fetcher.hfetchall(RedisKeys.hashKuaishouToken(), KuaishouTokenVo.class);
        if (MapUtils.isEmpty(map)) {
            return;
        }
        for (String key : map.keySet()) {
            KuaishouTokenVo kuaishouTokenVo = map.get(key);
            if (Objects.isNull(kuaishouTokenVo)) {
                continue;
            }
            List<Long> advertiserIds = kuaishouTokenVo.getAdvertiserIds();
            String appKey = kuaishouTokenVo.getAppKey();
            String secret = kuaishouTokenVo.getSecret();
            String refreshToken = kuaishouTokenVo.getRefreshToken();

            try {
                Map<String, Object> refreshParams = Maps.newHashMap();
                refreshParams.put("app_id", key);
                refreshParams.put("secret", secret);
                refreshParams.put("refresh_token", refreshToken);
                String refreshResult = OkHttpUtils.postRequestBody(refreshUrl, refreshParams, new HashMap<>());

                log.info("kuaishou refresh Response: {}", refreshResult);

                KuaishouAuthResponse kuaishouAuthResponse = JsonHelper.convert(refreshResult, KuaishouAuthResponse.class);
                if (kuaishouAuthResponse.getCode() != 0) {
                    return;
                }

                KuaishouAuthResponse.Data data = kuaishouAuthResponse.getData();

                Long exDate = System.currentTimeMillis() + Long.valueOf(data.getAccess_token_expires_in()) * 1000;
                Long refreshExDate = System.currentTimeMillis() + Long.valueOf(data.getRefresh_token_expires_in()) * 1000;
                String exDateFormat = DateUtil.dateTo14String(new Date(exDate));

                kuaishouTokenVo.setTokenExpireTime(exDateFormat);
                kuaishouTokenVo.setToken(data.getAccess_token());
                kuaishouTokenVo.setRefreshToken(data.getRefresh_token());
                kuaishouTokenVo.setRefreshExpireTime(DateUtil.dateTo14String(new Date(refreshExDate)));
                updater.hupdate(RedisKeys.hashKuaishouToken(), key, JsonHelper.convert(kuaishouTokenVo));

                Map<String, String> multiUpdateMap = new HashMap();
                for (Long advertiser_id : advertiserIds) {
                    // 更新rtb控制redis
                    Map<String, String> valueMap = new HashMap<>();
                    valueMap.put("accessToken", data.getAccess_token());
                    valueMap.put("expire", exDateFormat);

                    multiUpdateMap.put(Objects.toString(advertiser_id), JSONObject.toJSONString(valueMap));
                }
                rtbJedisUpdater.hmupdate(RedisKeys.hashRtbKuaishouAccessToken(appKey), multiUpdateMap);

            } catch (Exception e) {
                log.error("kuaishou job occur error :" + e.getMessage(), e);
            }

            log.info("kuaishou job execute is finished!");

        }

    }

    public static void main(String[] args) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString("https://developers.e.kuaishou.com/tools/authorize?app_id=165899974&scope=%5B%22ad_query%22%2C%22ad_manage%22%2C%22report_service%22%2C%22account_service%22%2C%22public_dmp_service%22%2C%22public_agent_service%22%2C%22public_account_service%22%5D&redirect_uri=https://www.baidu.com/&state=abcd&oauth_type=advertiser");
        String redirect_url = uriComponentsBuilder.replaceQueryParam("redirect_uri", "https://mgr.bianxianmao.com:18501/kuaishou/callback?appKey%3D757e39a645e9482e965a87cc28ee3b27%26appId%3D165899974")
                .replaceQueryParam("state", "abcd")
                .replaceQueryParam("oauth_type", "advertiser")
                .build()
                .toString();
        System.out.println(redirect_url);

    }
}
