package com.bxm.adsmanager.timer.media;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bxm.adsmanager.dal.mapper.media.MediaTestMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.model.dao.media.AdMediaTest;
import com.bxm.adsmanager.model.dto.mediamanager.PositionWeightDto;
import com.bxm.adsmanager.service.mediamanager.PositionTicketWeightService;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.util.StringUtil;

/**
 * @Title: MediaPositonTestJob
 * @Description:定时器定时修改媒体测试的广告位权重系数
 * @author 拉拉
 * @date 2018年4月25日
 */
@Component
public class MediaPositonTestJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(MediaPositonTestJob.class);

    private static final short          IS_USE = 1;

    @Autowired
    private MediaTestMapper             mediaTestMapper;

    @Autowired
    private ProdPullerIntegration       pullerIntegration;

    @Autowired
    private PositionTicketWeightService positionTicketWeightService;

    /**
     * @Title:
     * @Description: 定时器定时修改媒体测试的广告位权重系数
     * @author 拉拉
     * @date 2018年4月25日
     */
    //@Scheduled(cron = "0 0/5 * * * *") // 每5分钟执行一次
    public void updateWeight() {    
        LOGGER.info("开始执行定时器");
        List<AdMediaTest> adMediaTestList = mediaTestMapper.findAdMediaTestByIsUse();
        List<String> tickets = new ArrayList<>();
        // 如果列表为空，代表没有测试的券
        if (CollectionUtils.isNotEmpty(adMediaTestList)) {
            //查找缓存中所有的的券
            Map<String, Ticket> ocpcMap = pullerIntegration.fetchTicketAll();
           
            for (AdMediaTest adMediaTest : adMediaTestList) {
                //LOGGER.info("广告位id是+" + adMediaTest.getPositionId() );
                Boolean b = true;
                // 开始时间在当前时间之后，说明还没开始
                if (after(adMediaTest.getStartTime(), new Date())) {
                    continue;
                }
                //暂停状态不修改
                if (adMediaTest.getState()==3){
                    continue;
                }    
                // 根据 入口id去redis查找是否有点击数据
                Map<String, Long> mapCount = pullerIntegration.fetchPositionTestClickPvCount(adMediaTest.getPositionId()); 
                //LOGGER.info("广告位id是+" + adMediaTest.getPositionId() );
                // 代表有点击
                if ( mapCount != null && !mapCount.isEmpty()) {
                    tickets = getTicketIdList(adMediaTest.getTicketId().split(","));
                    //LOGGER.info("券id集合是+" + tickets );
                    //根据每张券的点击和它的点击阈值做比较，如果大于，则修改权重系数为100，如果小于则修改权重系数为1000
                    for (String ticketId : mapCount.keySet()) {
                        //LOGGER.info("将要修改权重的券id是" + ticketId );
                        // 如果券点击不等于空 ，并且小于点击阈值，系数改为1000
                        if( ocpcMap.get(ticketId).getCloseThreshold() ==null) {
                            continue;
                        }
                        if (mapCount.get(ticketId) == null
                            || (mapCount.get(ticketId) != null && mapCount.get(ticketId) < ocpcMap.get(ticketId).getCloseThreshold())) {
                           // LOGGER.info("权重系数改为1000---" + ticketId );
                            // 权重系数改为1000
                            updatePositionWeight(1000.0, adMediaTest.getPositionId(), ticketId);
                            // 移除这张券
                            tickets.remove(ticketId);
                            b = false;
                        } else {
                            //LOGGER.info("权重系数改为100--" + ticketId );
                            // 代表点击已经足够，权重系数改为100
                            updatePositionWeight(100.0, adMediaTest.getPositionId(), ticketId);
                            // 移除这张券
                            tickets.remove(ticketId);
                        }
                    }
                    // 第三种情况， 已经发了的券都修改了，没有发的还没有修改，
                    if (CollectionUtils.isNotEmpty(tickets)) {
                        b = false;
                        //LOGGER.info("剩余权重系数改为1000---" + tickets );
                        for (String ticketId : tickets) {                      
                            updatePositionWeight(1000.0, adMediaTest.getPositionId(), ticketId);
                        }
                    }

                } else {
                    b = false;
                    // 一个曝光没有的统一改为1000 
                    //LOGGER.info("一个曝光没有的统一改为1000--" + tickets );
                    updatePositionWeight(1000.0, adMediaTest.getPositionId(), adMediaTest.getTicketId());
                }
                if (b) {// 代表着可以修改数据字段了
                    AdMediaTest at = new AdMediaTest();
                    at.setId(adMediaTest.getId());
                    at.setIsUseByWeight(IS_USE);
                    mediaTestMapper.update(at);
                    LOGGER.info("权重修改完成");
                }
                tickets.clear();
            }
        }
    }

    public void updatePositionWeight(double interventionFactor, String positionId, String ticketId) {
        PositionWeightDto record = new PositionWeightDto();
        record.setInterventionFactor(interventionFactor);
        record.setPositionId(positionId);
        record.setTicketIdChar(ticketId);
        positionTicketWeightService.updatePositionWeight(record);
    }

    public static List<String> getTicketIdList(String[] str) {
        List<String> list = new ArrayList<>();
        for (int i = 0; i < str.length; i++) {
            if (StringUtil.isNotBlank(str[i])) {
                list.add(str[i]);
            }
        }
        return list;
    }

    /**
     * data1在data2之后
     * 
     * @param date1
     * @param date2
     * @return
     */
    public static boolean after(Date date1, Date date2) {
        long date1Long = date1.getTime();
        long date2Long = date2.getTime();
        return after(date1Long, date2Long);
    }

    /**
     * 比较两个日期.如果data1>data2返回true; data1在data2之后
     * 
     * @param data1
     * @param data2
     * @return
     */
    public static boolean after(long data1, long data2) {
        if (data1 - data2 > 0) {
            return true;
        } else {
            return false;
        }
    }
 
}
