package com.bxm.adsmanager.timer.old;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.base.Mail;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.redis.RedisClient;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.role.RoleService;
import com.bxm.adsmanager.utils.DingtalkMsgUtil;
import com.bxm.adsmanager.utils.MailUtil;
import com.bxm.util.AliYunSmsUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author sunzs
 * @Description 广告主信息定时存redis
 * created on 2018/10/22
 */
@Component
public class AdvertiserJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserJob.class);

    private static final String DDJobUrl = "https://oapi.dingtalk.com/robot/send?access_token=";

    /*广告主余额不足redisKey*/
    public static final String MONEYINFUFFICIENT = "moneyInsufficient";

    /**
     * 广告主预设金额报警redisKey
     */
    public static final String PRESETALARM = "Alarm";

    @Value("${warn.ddToken}")
    private String warnDdToken;

    @Value("${jobControl}")
    private String state;

    @Value("${smsSecret}")
    private String smsSecret;

    @Value("${smsKey}")
    private String smsKey;

    @Autowired
    private AdShopIntegration adShopIntegration;

    @Autowired
    private AdTicketService adTicketService;

    @Autowired
    private RoleService roleService;

    @Autowired
    private RedisClient redisClient;

    private static final Integer ZERO = 0;


    /**
     * 定时器每小时更新保存广告主信息以及对应下面的的所有礼券
     * @throws Exception
     */
    //@Scheduled(cron="12 */1 * * * ?") //每10分钟更新一次
    //@Async
    public void saveAdvertiserAndTicket() throws Exception{

        if (state.equals("0")) {
            return;
        }
        Long start = System.currentTimeMillis();
        //查询所有广告主
        try {
            LOGGER.info("保存广告主信息开始了--------------");

            List<AdvertiserDto> advertiserList = adShopIntegration.getAdShopList(null);
            if (advertiserList == null || advertiserList.isEmpty()) {
                DingtalkMsgUtil.sendMsg(DDJobUrl + warnDdToken, "每小时定时任务，saveNewRedisAdCertificateMsgNew 查询所有广告主记录为空 -----------", false, null);
            }
            //查询所有cpc的广告券
            AdTicketSearchDto adTicketSearchDto = new AdTicketSearchDto();
            adTicketSearchDto.setSettleType((short) 1);
            List<AdTicket> list = adTicketService.queryTicketListByCondition(adTicketSearchDto);
            Map<String, String> map = new HashMap<>();
            //循环所有广告券，把所有cpc的券根据广告主id分类存放到map集合中
            for (AdTicket l : list) {
                String key = l.getAdvertiser() + "";
                String value = map.get(key);
                if (value != null) {
                    map.put(key, value + "," + l.getId().toString());
                } else {
                    map.put(key, l.getId().toString());
                }
            }
            //循环每个广告主，把对应的ids放到每个广告主下面
            for (AdvertiserDto advertiser1 : advertiserList) {
                //余额等于现金余额加上返点加上授信
                advertiser1.setBalance(getBalance(advertiser1));
                String key = advertiser1.getId().toString();
                advertiser1.setCertificateIds(map.get(key));
                //查询广告主对应的销售
                String saleMobile = "";
                if (advertiser1.getSale() != null) {
                    saleMobile = roleService.getUserMobile(advertiser1.getSale());
                }
                advertiser1.setSaleMobiel(saleMobile);
                //保存到redis里面去(默认db0)
                redisClient.set(ZERO, "advertiser:adshop:" + key, JSON.toJSONString(advertiser1));
            }
            Long end = System.currentTimeMillis();
            Date date = new Date(start);
            SimpleDateFormat sim =  new SimpleDateFormat( "yyyy-MM-dd kk:mm:ss");
            String time =  sim.format(date);
            LOGGER.info("广告主信息redis更新完成,耗时:" + (end - start) + "ms:当前时间" + time);

        }catch (Exception e){
            LOGGER.error("时器每小时更新保存广告主信息以及对应下面的的所有礼券出错"+e.getMessage(),e);
            DingtalkMsgUtil.sendMsg(DDJobUrl+ warnDdToken, "定时器每小时更新保存广告主信息以及对应下面的的所有礼券出错 -----------"+e, false, null);
        }

    }

    /**
     *
     * 功能描述: 广告主预设金额报警
     * @fileName:
     * @param:
     * @return:
     * @auther: sunzs
     * @date: 2018/10/22 14:49
     */
    @Deprecated
    //@Scheduled(cron="0 0/2 * * * ? ")
    public void adShopMoneyAlarm() {
        if (state.equals("0")) {
            return;
        }
        try {
            LOGGER.info("广告主预设金额报警开始了--------------");
            //检测广告主预警金额不足报警
            String[] adShopIds = new String[]{};
            String result = redisClient.get(ZERO,"adShopMoneyAlarm");
            if (StringUtils.isNotEmpty(result)){
                adShopIds = result.split(",");
            }
            if (adShopIds.length > ZERO){
                for (String adShop : adShopIds){
                    String adShopKey = adShop + PRESETALARM;
                    if (StringUtils.isEmpty(redisClient.get(ZERO,adShopKey))){
                        //解析json查找对应的广告主的全部信息以及他的ids
                        AdvertiserDto advertiser = (AdvertiserDto) JSONObject.parseObject(redisClient.get(ZERO,"advertiser:adshop:" + adShop), AdvertiserDto.class);
                        toMessage(PRESETALARM,advertiser,getParms(null,String.valueOf(advertiser.getPresetMoney())),
                                getParms(advertiser.getCompany(),String.valueOf(advertiser.getPresetMoney())),
                                setTemplate("您的广告账户余额已不足"+advertiser.getPresetMoney()+"元，为避免广告停止投放，请尽快安排充值"),
                                "SMS_115065043","SMS_114185025","广告主预设金额提醒");
                        LOGGER.info("有广告主账户余额不足----------------------");
                    }
                }
            }

        }catch (Exception e){
            DingtalkMsgUtil.sendMsg(DDJobUrl+ warnDdToken, "adShopMoneyAlarm", false, null);
        }


    }
    public static String setTemplate(String message){
        String str ="</br><p>尊敬的广告主,您好！</p><p>"+message+"</p></br><p style='width:100%;text-align:center; background:#ccc;'>登录查询  <a href='http://cpc.bianxianmao.com/'>http：//cpc.bianxianmao.com/</a></p></br><p>如果您没有注册过变现猫，请忽略此邮件。</p><p style='width:100%;text-align:right;'>客服电话：400 630 5186</p>";
        return str;
    }


    public BigDecimal getBalance(AdvertiserDto advertiser1){

        BigDecimal balance = advertiser1.getBalance();
        try {
            balance = advertiser1.getBalance().add(advertiser1.getRebateMoney()).add(advertiser1.getCreditMoney());
        }catch (Exception e){
            LOGGER.info(e.getMessage(),e);
        }
        return  balance;
    }


    /**
     * 拼接阿里云SMS参数
     * @param str1
     * @param str2
     * @return
     */
    public static String getParms(String str1,String str2){
        JSONObject jsonObject1 = new JSONObject();
        if(StringUtils.isNotEmpty(str1)){
            jsonObject1.put("advertiserName",str1);
        }
        if(StringUtils.isNotEmpty(str2)){
            jsonObject1.put("money",str2);
        }
        return jsonObject1.toJSONString();
    }

    private void toMessage(String adShopKey,AdvertiserDto advertiser,String mosgContent,String mosgContent2,String emailMessage,String msgTemplateCode,String msgTemplateCode2,String title) {

        try {
            //如果当前收益已经超出广告主余额则报警（短信,邮件）
            String key = advertiser.getId() + adShopKey;
            if(StringUtils.isEmpty(redisClient.get(ZERO,key))){
                //redis广告主报警内部开关
                if(redisClient.get(ZERO,"isAlarm").equals("success")){
                    //邮件报警
                    sendEmailMsg(title,emailMessage,advertiser.getEmail());
                    //短信报警（广告主）
                    AliYunSmsUtil.sendMsg(smsKey,smsSecret, "变现猫",advertiser.getMobile(),mosgContent,msgTemplateCode);
                }
                //短信报警（销售）
                if(advertiser.getSaleMobiel() != null){
                    AliYunSmsUtil.sendMsg(smsKey,smsSecret,"变现猫",advertiser.getSaleMobiel(),mosgContent2,msgTemplateCode2);
                }
                redisClient.set(ZERO,key,"success");
            }
        }catch (Exception e){
            LOGGER.info(e.getMessage());

            return;
        }
    }

    /**
     * 发送邮件
     */
    public static void sendEmailMsg(String title,String message,String sendUser){
        Mail mail = new Mail();
        mail.setHost("smtp.mxhichina.com");
        mail.setSender("service@bianxianmao.com");
        mail.setReceiver(sendUser); // 接收人
        mail.setUsername("service@bianxianmao.com"); // 登录账号
        mail.setPassword("ABCabc123"); // 发件人邮箱的登录密码
        mail.setSubject(title);
        mail.setMessage(message);
        new MailUtil().send(mail);
    }







}

