package com.bxm.adsmanager.timer.old;

import com.bxm.datapark.facade.ticket.service.TicketDataReportSevice;
import com.bxm.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author sunzs
 * created on 2018/10/22
 */
@Deprecated
@Component
public class DataParkJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(DataParkJob.class);

    @Value("${jobControl}")
    private String state;

    @Value("${datapark.url}")
    private String dataParkUrl;

    @Autowired
    private TicketDataReportSevice ticketDataReportSevice;

    //统计礼券,开发者,开发者渠道不同维度的广告报表数据
    //@Scheduled(cron="0 30 0 * * ?")
    public void saveTicketTask() {
        if (state.equals("0")) {
            return;
        }
        try {
            LOGGER.info("广告报表数据统计开始了----------------------");
            String datetime=getPreDate(DateUtil.dateTo8String(new Date()));
            //执行统计

            ticketDataReportSevice.spareCertificate(datetime);
            LOGGER.info("广告报表数据统计结束了----------------------");
        }catch (Exception e){
            LOGGER.error("This error is timeout,becase datapark2 use much time to deal this job!");
            LOGGER.error(e.getMessage());
        }


    }


    //按小时维度跑统计(每小时第五秒开始).
    //@Scheduled(cron="5 0 0-23 * * ?")
    public void saveTicketCountForHour(){
        if (state.equals("0")) {
            return;
        }
        try {
            LOGGER.info("广告报表数据小时维度统计开始了----------------------");
            //日期格式化
            SimpleDateFormat sdfDate= new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat sdfHour= new SimpleDateFormat("HH");
            //获取当前时间
            Date date = new Date(System.currentTimeMillis());
            //获取日期
            String datetime=sdfDate.format(date);
            //获取小时
            Integer hour=Integer.valueOf(sdfHour.format(date));
            if(Integer.valueOf(0).equals(hour)){
                //若是零点
                datetime= getPreDate(datetime);
                hour=23;
            }else{
                hour--;
            }
            //开始任务调度
            ticketDataReportSevice.spareCertificateForHour(datetime,hour);
            LOGGER.info("广告报表数据小时维度统计结束了----------------------");
        } catch (Exception e) {
            LOGGER.error("This error is timeout,becase datapark2 use much time to deal this job!");
            LOGGER.error(e.getMessage());
        }
    }


    public static String getPreDate(String dateTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = new GregorianCalendar();
        try {
            calendar.setTime(sdf.parse(dateTime));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        calendar.add(Calendar.DATE, -1);
        return sdf.format(calendar.getTime());
    }

}
