package com.bxm.adsmanager.timer.positionweight;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import com.bxm.adsmanager.dal.mapper.mediamanager.AdTicketPositionWeightNewMapper;
import com.bxm.adsmanager.integration.utils.DateUtil;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.mediamanager.AdTicketPositionWeightNew;
import com.bxm.adsmanager.model.dto.AdTicketPositionWeightNewDTO;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.JsonHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * @author tangx
 * @date 2021/5/12 17:37
 */
@Component
@Slf4j
public class PositionWeightJob {

    @Autowired
    private AdTicketPositionWeightNewMapper adTicketPositionWeightNewMapper;

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    @Autowired
    private Environment environment;

    /**
     * 删除已到期的广告位权重
     */
    public void deleteExpiredPositionWeight() {
        // 查出所有未删除的权重配置
        AdTicketPositionWeightNewDTO dto = new AdTicketPositionWeightNewDTO();
        List<AdTicketPositionWeightNew> all = adTicketPositionWeightNewMapper.findAll(dto);

        if (CollectionUtils.isEmpty(all)) {
            return;
        }
        // 判断是否小于等于当前时间
        for (AdTicketPositionWeightNew weight : all) {
            Date stopTime = weight.getStopTime();
            if (null == stopTime) {
                continue;
            }

            List<String> activeProfiles = Arrays.asList(environment.getActiveProfiles());
            if (activeProfiles.contains(CommonConstant.Environment.PROFILES_DEV)
                    || activeProfiles.contains(CommonConstant.Environment.PROFILES_TEST)) {
                //测试
            } else {
                //线上
                //FIXME 这里为什么要增加13个小时，因为线上的数据库连接指定使用了GMT-8的时区,而在运营后台操作该数据时没有指定时区，所以导致时间校验有问题
                //FIXME 这里先临时解决判断的问题，后续有时间需要检查adsmanager-timer项目下所有使用时间判断或者更新相关的功能代码
                stopTime = DateUtil.increaseHour(stopTime, 13);
            }

            boolean afterStopTime = new Date().after(stopTime);
            if (afterStopTime) {
                // 更新db为已删除
                AdTicketPositionWeightNew adTicketPositionWeightNew = new AdTicketPositionWeightNew();
                adTicketPositionWeightNew.setId(weight.getId());
                adTicketPositionWeightNew.setStatus(AdTicketPositionWeightNew.STATUS_DELETE);
                adTicketPositionWeightNewMapper.updateByPrimaryKeySelective(adTicketPositionWeightNew);
                // 删除redis数据
                updater.hremove(TicketKeyGenerator.positionTicketWeightNew(weight.getPositionId()),weight.getTicketId().toString());
                log.info("【广告位权重到期删除】id:{},广告位id:{},停止时间:{},weight:{}", weight.getId(), weight.getPositionCode(),
                        DateUtil.dateTo14String(stopTime), JsonHelper.convert(weight));
            }

        }
    }
}
