package com.bxm.adsmanager.timer.postitiontag;

import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.tbltag.TblAdPostionTag;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author tangxiao
 * @Description 广告位标签信息定时存redis
 * created on 2019/09/02
 */
@Component
public class PositionTagJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(PositionTagJob.class);


    @Autowired
    @Qualifier("jedisFetcherForFM")
    private Fetcher fetcher;


    @Autowired
    @Qualifier("jedisUpdaterForFM")
    private Updater updater;

    @Autowired
    private TblAdTagService tblAdTagService;

    /**
     * 定时器每小时更新保存广告位标签信息
     *
     * @throws Exception
     */
    public void updateAllPositionTag() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("更新保存广告位标签信息的job，执行开始");
        }
        long start = System.currentTimeMillis();

        // 查出所有postion 分类tag信息
        List<TblAdTagVo> allClassTag = tblAdTagService.findAllClassTag();
        // 转换为(Map<code,full_code_path>)
        Map<String, String> tagMap = allClassTag.stream().collect(Collectors.toMap(vo -> vo.getCode().toString(),  vo -> vo.getFullCodePath()));
        // 存入redis key: ADA:TAGS
        updater.hmupdate(TicketKeyGenerator.Tags.getTags(),tagMap);

        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("更新保存广告位标签信息的job执行完成,用时：{} ms!",(System.currentTimeMillis() - start ));
        }
    }


}

