package com.bxm.adsmanager.timer.precharge;

import com.bxm.adsmanager.dal.mapper.adprofit.AdProfitAllMapper;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdProfitAllMapperExt;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdProfitPositionMapperExt;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargeConfigMapper;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargePositionRecordMapper;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargeRecordMapper;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.utils.DateUtil;
import com.bxm.adsmanager.model.dao.adprofit.AdProfitAll;
import com.bxm.adsmanager.model.dao.adprofit.AdProfitPosition;
import com.bxm.adsmanager.model.dao.precharge.*;
import com.bxm.adsmanager.timer.old.AdvertiserJob;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.util.DingtalkMsgUtil;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

import static com.bxm.util.DateUtil.getTheDayBefore;

/**
 * @author tangx
 * @date 2020/5/13 11:28
 */
@Component
@Deprecated
public class PrechargeJob {

    private static final Logger logger = LoggerFactory.getLogger(PrechargeJob.class);

    @Autowired
    private AdProfitPositionMapperExt adProfitPositionMapperExt;

    @Autowired
    private PrechargeConfigMapper prechargeConfigMapper;

    @Autowired
    private PrechargeRecordMapper prechargeRecordMapper;

    @Autowired
    private PrechargePositionRecordMapper prechargePositionRecordMapper;

    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    @Autowired
    @Qualifier("dingDingMessageSender")
    private MessageSender messageSender;

    @Autowired
    private AdProfitAllMapperExt adProfitAllMapperExt;


    /**
     * 新增预充管理广告位消耗记录 以及扣除预充账户余额
     */
    public void updatePrechargeRecord() {
        logger.info("【预充管理定时任务】开始执行");

        // 昨日日期
        String date = DateUtil.dateTo8String(getTheDayBefore(new Date()));
        // 防止重复，先查询日期是否有数据，有消耗数据就不更新
        PrechargeRecordExample example = new PrechargeRecordExample();
        example.createCriteria().andDatetimeEqualTo(date).andTypeEqualTo(PrechargeRecord.TYPE_CONSUME).andRecordTypeEqualTo(PrechargeRecord.RECORD_TYPE_NORMAL);
        long count = prechargeRecordMapper.countByExample(example);
        if (count > 0) {
            logger.info("【预充管理定时任务】已有昨日日期的数据，本次执行不做任何更新");
            return;
        }
        // 没有数据的话再看看tbl_ad_profit_all 表里的status是不是1已录入，不是直接返回
        AdProfitAll adProfitAll = adProfitAllMapperExt.findAdProfitAllBydatetime(date);
        if (adProfitAll == null || (adProfitAll != null && ObjectUtils.notEqual(AdProfitAll.STATUS_PAUSE_SUBMIT, adProfitAll.getStatus()))) {
            logger.info("【预充管理定时任务】tbl_ad_profit_all表status为{}，数据还未录入，本次执行不做任何更新", adProfitAll.getStatus());
            return;
        }

        List<AdProfitPosition> positionByDatetime = adProfitPositionMapperExt.findPositionByDatetimeV2(date);
        if (CollectionUtils.isEmpty(positionByDatetime)) {
            logger.info("【预充管理定时任务】tbl_ad_profit_position表无昨日的广告位记录");
            messageSender.send2(getDingdingMessage("【预充管理定时任务】tbl_ad_profit_position表无对应的广告位记录"));
            return;
        }

        // 广告位和收益转成kv map
        Map<String, AdProfitPosition> positionProfitMap = positionByDatetime.stream().collect(Collectors.toMap(p -> p.getPositionId(), p -> p));

        // 查询出所有的预充账户
        List<PrechargeConfig> prechargeConfigs = prechargeConfigMapper.selectByExampleWithBLOBs(new PrechargeConfigExample());
        if (CollectionUtils.isEmpty(prechargeConfigs)) {
            return;
        }

        // 获取所有配置的广告位Set
        Set<String> positionSet = new HashSet();
        prechargeConfigs.stream().forEach(p -> {
            String positions = p.getPositions();
            if (StringUtils.isBlank(positions)) {
                return;
            }
            List<String> positionList = Arrays.asList(positions.split(","));
            if (CollectionUtils.isEmpty(positionList)) {
                return;
            }
            positionSet.addAll(positionList);
        });

        List<AppEntranceAdRO> listByPositionIds = newAppEntranceFacadeIntegration.findListByPositionIds(new ArrayList<>(positionSet));

        // 广告位id-广告位名称 Map
        Map<String, String> positionNameMap = listByPositionIds.stream().collect(Collectors.toMap(p -> p.getPositionId(), p -> p.getAppEntranceName()));

        // 遍历每个账户下的所有广告位，更新扣款以及同步广告位数据记录
        prechargeConfigs.forEach(p ->{
            String positions = p.getPositions();
            if (StringUtils.isBlank(positions)) {
                return;
            }
            List<String> positionList = Arrays.asList(positions.split(","));
            if (CollectionUtils.isEmpty(positionList)) {
                return;
            }
            // 账户下需要扣款的金额 单位：厘
            AtomicInteger accountTotalDeduct = new AtomicInteger();

            Long accountId = p.getId();
            positionList.forEach(positionId -> {
                AdProfitPosition adProfitPosition = positionProfitMap.get(positionId);
                // 广告位昨日的数据导入到 position_record表
                if (adProfitPosition != null) {
                    PrechargePositionRecord prechargePositionRecord = new PrechargePositionRecord();
                    prechargePositionRecord.setAccountId(accountId);
                    // 厘转元
                    prechargePositionRecord.setConsume(parseAmountOfYuan(adProfitPosition.getProfitActual()));
                    prechargePositionRecord.setDatetime(date);
                    prechargePositionRecord.setPositionName(positionNameMap.get(positionId));
                    prechargePositionRecord.setPositionId(positionId);
                    int i = prechargePositionRecordMapper.insertSelective(prechargePositionRecord);
                    if (i == 0) {
                        logger.error("【预充管理定时任务】新增广告位记录失败，accountId = {}", accountId);
                        messageSender.send2(getDingdingMessage("【预充管理定时任务】新增广告位记录失败，accountId = " + accountId));
                    }
                    accountTotalDeduct.addAndGet(adProfitPosition.getProfitActual());
                }

            });

            BigDecimal accountTotalDeductYuan = parseAmountOfYuan(accountTotalDeduct.get());
            if (accountTotalDeduct.get() != 0) {
                // 预充配置余额 扣除所绑定广告位的消耗
                int i = prechargeConfigMapper.updateBalanceDeduct(accountId, accountTotalDeductYuan);
                if (i == 0) {
                    logger.error("【预充管理定时任务】扣除金额失败，accountId = {}", accountId);
                    messageSender.send2(getDingdingMessage("【预充管理定时任务】扣除金额失败，accountId = " + accountId));
                }
            }
            PrechargeRecord prechargeRecord = buildPrechargeRecord(p, accountTotalDeductYuan, date);
            int i1 = prechargeRecordMapper.insertSelective(prechargeRecord);
            if (i1 == 0) {
                logger.error("【预充管理定时任务】新增消耗记录失败，accountId = {}", accountId);
                messageSender.send2(getDingdingMessage("【预充管理定时任务】新增消耗记录失败，accountId =" + accountId));
            }

        });
        logger.info("【预充管理定时任务】执行完毕！");
    }


    private PrechargeRecord buildPrechargeRecord(PrechargeConfig p, BigDecimal accountTotalDeductYuan, String date) {
        PrechargeRecord prechargeRecord = new PrechargeRecord();
        prechargeRecord.setAccountId(p.getId());
        prechargeRecord.setAccountName(p.getAccountName());
        prechargeRecord.setConsumeAmount(accountTotalDeductYuan);
        prechargeRecord.setBalance(p.getBalance().subtract(accountTotalDeductYuan));
        prechargeRecord.setDatetime(date);
        prechargeRecord.setType(PrechargeRecord.TYPE_CONSUME);
        return prechargeRecord;
    }

    /**
     * 厘转元
     * @return
     */
    public static BigDecimal parseAmountOfYuan(Integer amountOfLi) {
        BigDecimal amountOfYuan = new BigDecimal(amountOfLi).divide(new BigDecimal(1000), 2, BigDecimal.ROUND_HALF_UP);
        return amountOfYuan;
    }

    private Message getDingdingMessage(String content) {
        Message message = new Message();
        message.setContent(content);
        message.setTos(null);
        return message;
    }

}
