package com.bxm.adsmanager.timer.weibo;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.integration.getui.utils.HttpUtils;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.vo.weibo.WBToken;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.rtb.impl.PositionRTBServiceImpl;
import com.bxm.adsmanager.utils.DoubleUtil;
import com.bxm.util.DateUtil;
import com.bxm.util.DingtalkMsgUtil;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;


/**
 * @author 拉拉
 * @Title: WeiboJob
 * @Description:微博的定时任务
 * @date 2020年03月05日
 */
@Slf4j
@Component
public class WeiboJob {


    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    @Autowired
    private JedisFetcher fetcher;

    private static final String tokenUrl = "http://api.biz.weibo.com/oauth/token";

    /**
     * @Title:
     * @Description: 微博的定时刷新接口
     * @author 拉拉
     * @date 2021年7月5日
     */
    public void execute() {
        Map<String, WBToken> map = fetcher.hfetchall(CommonConstant.wbToken(), WBToken.class);
        if (map == null) {
            return;
        }
        for (String key : map.keySet()) {
            WBToken wbToken = map.get(key);
            if (Objects.isNull(wbToken)) {
                continue;
            }
            try {
                Map<String, Object> refreshParams = Maps.newHashMap();
                refreshParams.put("client_id", key);
                refreshParams.put("grant_type", "refresh_token");
                refreshParams.put("refresh_token", wbToken.getRefresh_token());
                String refreshTokenurl = OkHttpUtils.appendParams(tokenUrl, refreshParams);
               // String refreshValue = OkHttpUtils.get(refreshTokenurl);

                CloseableHttpClient httpClient = HttpUtils.CreatHttpClient();
                HttpGet httpGet = HttpUtils.getHttpGet(refreshTokenurl);
                CloseableHttpResponse httpResp = httpClient.execute(httpGet);
                String refreshValue = EntityUtils.toString(httpResp.getEntity());


                WBToken refreshToken = JsonHelper.convert(refreshValue, WBToken.class);
                Long exDate = System.currentTimeMillis() + Long.valueOf(refreshToken.getExpires_in()) * 1000;
                refreshToken.setExDate(DateUtil.dateTo14String(new Date(exDate)));
                refreshToken.setRefresh_token(wbToken.getRefresh_token());
                refreshToken.setRefresh_expires_in(wbToken.getRefresh_expires_in());
                refreshToken.setRefreshExDate(wbToken.getRefreshExDate());
                updater.hupdate(CommonConstant.wbToken(), key, JsonHelper.convert(refreshToken));
            } catch (Exception e) {
                log.error("weibo refresh_token error ,appId : {}  error {}", key, e.getMessage());

            }


        }


    }

    public static void main(String[] args) throws  Exception {
        Map<String, Object> refreshParams = Maps.newHashMap();
        refreshParams.put("client_id", "202207072115175100");
        refreshParams.put("grant_type", "refresh_token");
        refreshParams.put("refresh_token", "r81949e1298c69ccc1ffe7b0f92482be");
        String refreshTokenurl = OkHttpUtils.appendParams(tokenUrl, refreshParams);
        // String refreshValue = OkHttpUtils.get(refreshTokenurl);

        CloseableHttpClient httpClient = HttpUtils.CreatHttpClient();
        HttpGet httpGet = HttpUtils.getHttpGet(refreshTokenurl);
        CloseableHttpResponse httpResp = httpClient.execute(httpGet);
        String refreshValue = EntityUtils.toString(httpResp.getEntity());


        WBToken refreshToken = JsonHelper.convert(refreshValue, WBToken.class);
        System.out.println(JSON.toJSONString(refreshToken));
       /* Long exDate = System.currentTimeMillis() + Long.valueOf(refreshToken.getExpires_in()) * 1000;
        refreshToken.setExDate(DateUtil.dateTo14String(new Date(exDate)));
        refreshToken.setRefresh_token(wbToken.getRefresh_token());
        refreshToken.setRefresh_expires_in(wbToken.getRefresh_expires_in());
        refreshToken.setRefreshExDate(wbToken.getRefreshExDate());*/
    }

}
