package com.bxm.adsmanager.timer.youdao;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.utils.DoubleUtil;
import com.bxm.util.DateUtil;
import com.bxm.util.DingtalkMsgUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.Date;
import java.util.List;


/**
 * @author 拉拉
 * @Title: YDTimerJob
 * @Description:有道券的定时任务
 * @date 2020年03月05日
 */
@Component
public class YDTimerJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(YDTimerJob.class);

    private static final short IS_USE = 1;

    @Value("${yd.ticketIds}")
    private String ticketIds;

    @Autowired
    private AdTicketService adTicketService;

    @Autowired
    private AdTicketAssetsService adTicketAssetsService;

    @Autowired
    private ProdPullerIntegration pullerIntegration;

    public static final String url = "https://oapi.dingtalk.com/robot/send?access_token=c26b02268d084a2af29e27e31ccfb708b4fef65c94396ab3c547595c4b02423e";

    /**
     * @Title:
     * @Description: 定时查找有道券的曝光于点击 是否小于0.95
     * @author 拉拉
     * @date 2018年4月25日
     */
    public void execute() {
        if (StringUtils.isEmpty(ticketIds)) {
            return;
        }
        //第一步查找所有开启的券
        List<AdTicket> openTicketList = adTicketService.findByIds(ticketIds);
        //没有开启的券，返回
        if (CollectionUtils.isEmpty(openTicketList)) {
            return;
        }
        String date = DateUtil.dateTo8String1(new Date());
        int totalCount = 0;
        //关掉素材的曝光
        int closeAssetsViewcount = 0;
        for (AdTicket adTicket : openTicketList) {
            if (adTicket.getStatus() != 1) {
                continue;
            }
            //根据券ID，查找所有的素材
            List<AdAssets> assets = adTicketAssetsService.findAllAssetsById(adTicket.getId());
            if (CollectionUtils.isEmpty(assets)) {
                continue;
            }
            //开始查找所有素材的总曝光和
            for (AdAssets adAssets : assets) {
                //开启的素材
                if (adAssets.getStatus() == 1) {
                    totalCount += pullerIntegration.fetchAssetAllViewPvCount(adAssets.getId().toString(), date);
                } else {
                    closeAssetsViewcount = pullerIntegration.fetchAssetAllViewPvCount(adAssets.getId().toString(), date);
                    totalCount += closeAssetsViewcount;
                }
            }
            //开始计算是否小于0.95 ，小于0.95 开始报警，小于0.9 直接关闭券
            Double value = DoubleUtil.formatDouble(String.valueOf(closeAssetsViewcount), String.valueOf(totalCount));
            if (value < 85 && value > 0) {
                try {
                    adTicket.setStatus((short) 3);
                    adTicketService.updateStatus(adTicket);
                    //报警
                    DingtalkMsgUtil.sendMsg(url, "券ID: " + adTicket.getId() + " 该券的素材曝光占比已低于85%,现在曝光占比是"+value+"%,已关闭该券,请及时查看", false, null);
                } catch (Exception e) {
                    //报警
                    DingtalkMsgUtil.sendMsg(url, "券ID: " + adTicket.getId() + " 该券的素材曝光占比已低于90%,关闭券失败,现在曝光占比是"+value+"%请手动关闭", false, null);
                }
            }
            if (value >= 90 && value <= 95) {
                //报警
                DingtalkMsgUtil.sendMsg(url, "券ID: " + adTicket.getId() + " 该券的素材曝光占比已低于95%,现在曝光占比是"+value+"%请及时查看", false, null);
            }
            closeAssetsViewcount = 0;
            totalCount = 0;
        }
    }


}
