/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.api.adapter.iqiyi;

import com.bxm.pangu.rta.api.adapter.RejectResponseModelAdapter;
import com.bxm.pangu.rta.api.adapter.iqiyi.request.IqiyiRequestProto;
import com.bxm.pangu.rta.api.adapter.iqiyi.response.IqiyiResponseProto;
import com.bxm.pangu.rta.api.constant.RtaMedia;
import com.bxm.pangu.rta.api.exception.ErrorCode;
import com.bxm.pangu.rta.api.model.QueryRequest;
import com.bxm.pangu.rta.api.model.QueryResponse;
import com.bxm.pangu.rta.common.RtaRequest;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Component;

@Component
public class IqiyiModelAdapter
implements RejectResponseModelAdapter {
    private static final int SUCCESS_CODE = 0;
    private static final int FAIL_CODE = 1;

    public static void main(String[] args) {
        IqiyiRequestProto.RTARequest_2_0 iqiyiRequest = IqiyiRequestProto.RTARequest_2_0.newBuilder().setIdfaMd5("Nvwa_1FCB72BC235C4F01BC9CE6ED082").setPlatform(32).addAdvertiserIds(1001L).build();
        try {
            FileUtils.writeByteArrayToFile((File)new File("D:/dd.protobuf"), (byte[])iqiyiRequest.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IqiyiModelAdapter iqiyiModelAdapter = new IqiyiModelAdapter();
        iqiyiModelAdapter.request(iqiyiRequest.toByteArray());
    }

    @Override
    public QueryRequest request(byte[] requestBody) {
        QueryRequest queryRequest = new QueryRequest();
        IqiyiRequestProto.RTARequest_2_0 iqiyiRequest = null;
        try {
            iqiyiRequest = IqiyiRequestProto.RTARequest_2_0.parseFrom(requestBody);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        queryRequest.setRtaId(this.findRtaId(iqiyiRequest));
        queryRequest.setRtaRequest(this.buildRtaRequest(iqiyiRequest));
        return queryRequest;
    }

    private RtaRequest buildRtaRequest(IqiyiRequestProto.RTARequest_2_0 iqiyiRequest) {
        RtaRequest rtaRequest = new RtaRequest();
        rtaRequest.setIdfa_md5(iqiyiRequest.getIdfaMd5());
        rtaRequest.setImei_md5(iqiyiRequest.getImeiMd5());
        rtaRequest.setOaid(iqiyiRequest.getOaid());
        int platform = iqiyiRequest.getPlatform();
        switch (platform) {
            case 32: {
                rtaRequest.setOs("ios");
                break;
            }
            case 33: {
                rtaRequest.setOs("android");
                break;
            }
            default: {
                rtaRequest.setOs("other");
            }
        }
        return rtaRequest;
    }

    @Override
    public byte[] response(QueryResponse response) {
        QueryRequest queryRequest = response.getQueryRequest();
        String rtaId = queryRequest.getRtaId();
        IqiyiResponseProto.ResultList_2_0 resultList = IqiyiResponseProto.ResultList_2_0.newBuilder().setAdvertiserId(Long.parseLong(rtaId)).setIsDeliver(response.isSuccess()).build();
        IqiyiResponseProto.RTAResponse_2_0 iqiyiResponse = IqiyiResponseProto.RTAResponse_2_0.newBuilder().addResult(resultList).setStatusCode(0).build();
        return iqiyiResponse.toByteArray();
    }

    @Override
    public String getRtaMedia() {
        return RtaMedia.IQIYI.getId();
    }

    @Override
    public String findRtaId(Object requestObject) {
        List<Long> advertiserIdsList;
        if (requestObject instanceof IqiyiRequestProto.RTARequest_2_0 && CollectionUtils.isNotEmpty(advertiserIdsList = ((IqiyiRequestProto.RTARequest_2_0)requestObject).getAdvertiserIdsList())) {
            return advertiserIdsList.iterator().next().toString();
        }
        return null;
    }

    @Override
    public byte[] reject(QueryRequest request, ErrorCode errorCode) {
        return this.buildErrorResponse();
    }

    private byte[] buildErrorResponse() {
        IqiyiResponseProto.RTAResponse_2_0 iqiyiResponse = IqiyiResponseProto.RTAResponse_2_0.newBuilder().setStatusCode(1).build();
        return iqiyiResponse.toByteArray();
    }
}

