/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.api.aop;

import com.bxm.adsprod.facade.rta.RtaConfig;
import com.bxm.adsprod.facade.rta.RtaKeyGenerator;
import com.bxm.pangu.rta.api.exception.ErrorCode;
import com.bxm.pangu.rta.api.exception.RejectQueryException;
import com.bxm.pangu.rta.api.exception.RtaQueryException;
import com.bxm.pangu.rta.api.model.QueryRequest;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class QueryRequestAspect
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(QueryRequestAspect.class);
    private final JedisFetcher jedisFetcher;

    public QueryRequestAspect(JedisFetcher jedisFetcher) {
        this.jedisFetcher = jedisFetcher;
    }

    @Pointcut(value="this(com.bxm.pangu.rta.api.service.RtaDispatcher) && execution(* dispatch(..))")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void before(JoinPoint point) {
        Object[] args = point.getArgs();
        if (ArrayUtils.isEmpty((Object[])args)) {
            return;
        }
        Object firstArg = args[0];
        if (!(firstArg instanceof QueryRequest)) {
            return;
        }
        QueryRequest queryRequest = (QueryRequest)firstArg;
        String rtaId = queryRequest.getRtaId();
        if (StringUtils.isBlank((String)rtaId)) {
            throw new RejectQueryException(ErrorCode.Missing_Rta_Id);
        }
        if (Objects.nonNull(queryRequest.getRtaConfig())) {
            return;
        }
        RtaConfig rtaConfig = (RtaConfig)this.jedisFetcher.fetch(RtaKeyGenerator.getRtaConfig((String)rtaId), RtaConfig.class);
        if (Objects.isNull(rtaConfig)) {
            throw new RejectQueryException(ErrorCode.Invalid_Rta_Id);
        }
        try {
            this.checkRtaConfig(rtaConfig);
        }
        catch (RtaQueryException e) {
            if (log.isInfoEnabled()) {
                log.info(e.getMessage(), (Throwable)e);
            }
            throw new RejectQueryException(ErrorCode.Unknown);
        }
        RtaRequest rtaRequest = queryRequest.getRtaRequest();
        rtaRequest.setParam(rtaConfig.getRtaParam());
        queryRequest.setRtaConfig(rtaConfig);
    }

    private void checkRtaConfig(RtaConfig rtaConfig) {
        String rtaId = rtaConfig.getRtaId();
        this.checkCondition(rtaConfig.enable(), "rtaConfig is disable - rtaId: " + rtaId);
        this.checkCondition(Objects.nonNull(rtaConfig.getSourceType()), "sourceType cannot be null  - rtaId: " + rtaId);
        this.checkCondition(Objects.nonNull(rtaConfig.getQps()), "qps cannot be null  - rtaId: " + rtaId);
    }

    private void checkCondition(boolean condition, String message) {
        if (!condition) {
            throw new RtaQueryException(message);
        }
    }

    public int getOrder() {
        return -2147483647;
    }
}

