/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.api.autoconfigure;

import com.bxm.pangu.rta.api.config.RtaApiProperties;
import com.bxm.pangu.rta.api.mq.AlionsHttpConsumer;
import com.bxm.pangu.rta.api.mq.AlionsHttpProperties;
import com.bxm.warcar.integration.pushable.CachePushableBus;
import com.bxm.warcar.integration.pushable.message.CachePushableMessageListener;
import com.bxm.warcar.mq.Listener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PushableConsumerAutoConfiguration {
    private final RtaApiProperties properties;

    public PushableConsumerAutoConfiguration(RtaApiProperties properties) {
        this.properties = properties;
    }

    @Bean
    public CachePushableMessageListener cachePushableMessageListener(CachePushableBus cachePushableBus) {
        String topic = this.properties.getMqHttp().getSync().getTopic();
        String groupId = this.properties.getMqHttp().getSync().getGroupId();
        return new CachePushableMessageListener(topic, groupId, cachePushableBus);
    }

    @Bean(initMethod="init", destroyMethod="destroy")
    public AlionsHttpConsumer cachePushableConsumer(CachePushableBus cachePushableBus) {
        CachePushableMessageListener listener = this.cachePushableMessageListener(cachePushableBus);
        RtaApiProperties.MqHttp http = this.properties.getMqHttp();
        AlionsHttpProperties alions = AlionsHttpProperties.builder().endpoint(http.getEndpoint()).accessKey(http.getAccessKey()).secretKey(http.getSecretKey()).groupId(listener.getConsumerId()).instanceId(http.getInstanceId()).num(http.getNum()).pollingSecond(http.getPollingSecond()).build();
        return new AlionsHttpConsumer(alions, (Listener)listener);
    }
}

