/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.api.controller;

import com.bxm.pangu.rta.api.adapter.ModelAdapter;
import com.bxm.pangu.rta.api.adapter.ModelAdapterFactory;
import com.bxm.pangu.rta.api.adapter.RejectResponseModelAdapter;
import com.bxm.pangu.rta.api.exception.ErrorCode;
import com.bxm.pangu.rta.api.exception.RejectQueryException;
import com.bxm.pangu.rta.api.exception.RtaQueryException;
import com.bxm.pangu.rta.api.model.QueryRequest;
import com.bxm.pangu.rta.api.model.QueryResponse;
import com.bxm.pangu.rta.api.service.RtaDispatcher;
import com.bxm.pangu.rta.api.util.ServletUtils;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RtaController {
    private static final Logger log = LoggerFactory.getLogger(RtaController.class);
    private final ModelAdapterFactory modelAdapterFactory;
    private final RtaDispatcher rtaDispatcher;

    public RtaController(ModelAdapterFactory modelAdapterFactory, RtaDispatcher rtaDispatcher) {
        this.modelAdapterFactory = modelAdapterFactory;
        this.rtaDispatcher = rtaDispatcher;
    }

    @RequestMapping(value={"/query/{name}"}, method={RequestMethod.POST, RequestMethod.GET})
    public void query(@PathVariable(value="name") String name, HttpServletRequest request, HttpServletResponse response) {
        block7: {
            ModelAdapter modelAdapter = (ModelAdapter)this.modelAdapterFactory.get(name);
            if (null == modelAdapter) {
                return;
            }
            QueryRequest queryRequest = null;
            try {
                byte[] body = this.getRequestBody(request);
                if (Objects.isNull(body)) {
                    throw new RtaQueryException("cannot get content by request: " + name);
                }
                queryRequest = modelAdapter.request(body);
                QueryResponse queryResponse = this.rtaDispatcher.dispatch(queryRequest);
                if (Objects.isNull(queryResponse)) {
                    throw new RejectQueryException(ErrorCode.Unknown);
                }
                byte[] r = modelAdapter.response(queryResponse);
                ServletUtils.println(response, r, modelAdapter.headers());
            }
            catch (Exception e) {
                ErrorCode errorCode = null;
                if (e instanceof RejectQueryException) {
                    errorCode = ((RejectQueryException)e).getErrorCode();
                }
                if (!(e instanceof RtaQueryException)) {
                    log.error("query occur exception: ", (Throwable)e);
                }
                this.printRejectQueryException(queryRequest, e);
                if (!(modelAdapter instanceof RejectResponseModelAdapter)) break block7;
                RejectResponseModelAdapter rejectResponseModelAdapter = (RejectResponseModelAdapter)modelAdapter;
                response.setStatus(rejectResponseModelAdapter.statusCode(errorCode));
                ServletUtils.println(response, rejectResponseModelAdapter.reject(queryRequest, errorCode), modelAdapter.headers());
            }
        }
    }

    private void printRejectQueryException(QueryRequest queryRequest, Exception e) {
        if (e instanceof RtaQueryException) {
            RejectQueryException rejectQueryException = (RejectQueryException)e;
            ErrorCode errorCode = rejectQueryException.getErrorCode();
            if (log.isDebugEnabled()) {
                log.debug("Reject rta query: {}/ {}", (Object)(Objects.nonNull(queryRequest) ? queryRequest.getRtaId() : "?"), (Object)errorCode);
            }
        }
    }

    private byte[] getRequestBody(HttpServletRequest request) {
        byte[] body = request.getMethod().equals(RequestMethod.POST.name()) ? ServletUtils.getBodyForBuffer(request) : ServletUtils.convert2JsonBytes(request.getParameterMap());
        return body;
    }
}

