/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.api.service.hitter;

import com.bxm.adsprod.facade.rta.RtaConfig;
import com.bxm.pangu.rta.api.CacheKey;
import com.bxm.pangu.rta.api.config.DeviceCrowdPackageJedisProperties;
import com.bxm.pangu.rta.api.config.RtaApiProperties;
import com.bxm.pangu.rta.api.constant.SourceType;
import com.bxm.pangu.rta.api.model.QueryRequest;
import com.bxm.pangu.rta.api.service.QueryHitter;
import com.bxm.pangu.rta.api.util.limiter.DeleteExpiredHandler;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
public class CrowdPackageQueryHitter
implements QueryHitter {
    private final Fetcher fetcher;
    private final RtaApiProperties rtaApiProperties;
    private final DeviceCrowdPackageJedisProperties deviceCrowdPackageJedisProperties;
    private final DeleteExpiredHandler deleteExpiredHandler;

    public CrowdPackageQueryHitter(@Qualifier(value="deviceCrowdPackageFetcher") Fetcher fetcher, RtaApiProperties rtaApiProperties, DeviceCrowdPackageJedisProperties deviceCrowdPackageJedisProperties, @Qualifier(value="deleteExpiredDeviceCrowdPackageHandler") DeleteExpiredHandler deleteExpiredHandler) {
        this.fetcher = fetcher;
        this.rtaApiProperties = rtaApiProperties;
        this.deviceCrowdPackageJedisProperties = deviceCrowdPackageJedisProperties;
        this.deleteExpiredHandler = deleteExpiredHandler;
    }

    @Override
    public boolean query(QueryRequest queryRequest) {
        RtaConfig rtaConfig = queryRequest.getRtaConfig();
        String crowdPackageRule = rtaConfig.getCrowdPackageRule();
        Map<String, Integer> crowdPkgConfig = this.rtaApiProperties.getCrowdPkgConfig();
        if (StringUtils.isBlank((String)crowdPackageRule)) {
            // empty if block
        }
        RtaRequest rtaRequest = queryRequest.getRtaRequest();
        HashSet selectors = Sets.newHashSet();
        CrowdPackageOrientation crowdPackageOrientation = this.getCrowdPackEntity(crowdPackageRule);
        Set<String> allCrowdPackageIds = crowdPackageOrientation.getAll();
        for (String id : allCrowdPackageIds) {
            Integer selector = crowdPkgConfig.get(id);
            if (Objects.nonNull(selector)) {
                selectors.add(selector);
                continue;
            }
            selectors.add(this.deviceCrowdPackageJedisProperties.getNewDatabase());
        }
        List<String> userCrowdPkg = this.getCrowdPkg(rtaRequest, selectors);
        HashSet white = Sets.newHashSet(crowdPackageOrientation.getWhite());
        HashSet black = Sets.newHashSet(crowdPackageOrientation.getBlack());
        if (!CollectionUtils.isEmpty((Collection)black)) {
            black.retainAll(userCrowdPkg);
            if (!CollectionUtils.isEmpty((Collection)black)) {
                return false;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)white)) {
            white.retainAll(userCrowdPkg);
            if (CollectionUtils.isEmpty((Collection)white)) {
                return false;
            }
        }
        return true;
    }

    private List<String> getCrowdPkg(RtaRequest rtaRequest, Set<Integer> selectors) {
        KeyGenerator key = CacheKey.getCrowdPackageKey(rtaRequest);
        KeyGenerator newKey = CacheKey.getCrowdPackageNewKey(rtaRequest);
        if (Objects.isNull(key) && Objects.isNull(newKey)) {
            return Lists.newArrayList();
        }
        HashSet res = Sets.newHashSet();
        long currentSecond = System.currentTimeMillis() / 1000L;
        for (Integer selector : selectors) {
            String caching = null;
            if (selector < 0) {
                caching = (String)this.fetcher.fetch(key, String.class);
                if (!StringUtils.isNotBlank((String)caching)) continue;
                res.addAll(Sets.newHashSet((Object[])StringUtils.splitByWholeSeparator((String)caching, (String)",")));
                continue;
            }
            Map idAndExprieSecondMap = this.fetcher.hfetchallWithSelector(newKey, Long.class, selector.intValue());
            if (!MapUtils.isNotEmpty((Map)idAndExprieSecondMap)) continue;
            for (Map.Entry entry : idAndExprieSecondMap.entrySet()) {
                String id = (String)entry.getKey();
                if ((Long)entry.getValue() > currentSecond) {
                    res.add(id);
                    continue;
                }
                this.deleteExpiredHandler.delete(newKey, id);
            }
        }
        return Lists.newArrayList((Iterable)res);
    }

    public CrowdPackageOrientation getCrowdPackEntity(String crowdPackageRule) {
        if (StringUtils.isNotBlank((String)crowdPackageRule)) {
            String[] arr = StringUtils.splitPreserveAllTokens((String)crowdPackageRule, (String)"&");
            HashSet white = Sets.newHashSet((Object[])StringUtils.split((String)arr[0], (String)","));
            CrowdPackageOrientation entity = new CrowdPackageOrientation();
            entity.getAll().addAll(white);
            if (arr.length >= 2) {
                HashSet black = Sets.newHashSet((Object[])StringUtils.split((String)arr[1], (String)","));
                entity.setBlack(black);
                entity.getAll().addAll(black);
            }
            return entity.setWhite(white);
        }
        return null;
    }

    @Override
    public SourceType sourceType() {
        return SourceType.CROWD_PACKAGE;
    }

    public static class CrowdPackageOrientation {
        private Set<String> white = Sets.newHashSet();
        private Set<String> black = Sets.newHashSet();
        private Set<String> all = Sets.newHashSet();

        public Set<String> getWhite() {
            return this.white;
        }

        public Set<String> getBlack() {
            return this.black;
        }

        public Set<String> getAll() {
            return this.all;
        }

        public CrowdPackageOrientation setWhite(Set<String> white) {
            this.white = white;
            return this;
        }

        public CrowdPackageOrientation setBlack(Set<String> black) {
            this.black = black;
            return this;
        }

        public CrowdPackageOrientation setAll(Set<String> all) {
            this.all = all;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CrowdPackageOrientation)) {
                return false;
            }
            CrowdPackageOrientation other = (CrowdPackageOrientation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$white = this.getWhite();
            Set<String> other$white = other.getWhite();
            if (this$white == null ? other$white != null : !((Object)this$white).equals(other$white)) {
                return false;
            }
            Set<String> this$black = this.getBlack();
            Set<String> other$black = other.getBlack();
            if (this$black == null ? other$black != null : !((Object)this$black).equals(other$black)) {
                return false;
            }
            Set<String> this$all = this.getAll();
            Set<String> other$all = other.getAll();
            return !(this$all == null ? other$all != null : !((Object)this$all).equals(other$all));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CrowdPackageOrientation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $white = this.getWhite();
            result = result * 59 + ($white == null ? 43 : ((Object)$white).hashCode());
            Set<String> $black = this.getBlack();
            result = result * 59 + ($black == null ? 43 : ((Object)$black).hashCode());
            Set<String> $all = this.getAll();
            result = result * 59 + ($all == null ? 43 : ((Object)$all).hashCode());
            return result;
        }

        public String toString() {
            return "CrowdPackageQueryHitter.CrowdPackageOrientation(white=" + this.getWhite() + ", black=" + this.getBlack() + ", all=" + this.getAll() + ")";
        }
    }
}

