/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.api.service.hitter;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsprod.facade.rta.RtaConfig;
import com.bxm.pangu.rta.api.constant.SourceType;
import com.bxm.pangu.rta.api.model.QueryRequest;
import com.bxm.pangu.rta.api.service.QueryHitter;
import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaClientFactory;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RtaApiQueryHitter
implements QueryHitter {
    private static final Logger log = LoggerFactory.getLogger(RtaApiQueryHitter.class);
    private final RtaClientFactory rtaClientFactory;

    public RtaApiQueryHitter(RtaClientFactory rtaClientFactory) {
        this.rtaClientFactory = rtaClientFactory;
    }

    @Override
    public boolean query(QueryRequest queryRequest) {
        RtaConfig rtaConfig = queryRequest.getRtaConfig();
        RtaRequest rtaRequest = queryRequest.getRtaRequest();
        RtaType rtaType = RtaType.of((int)rtaConfig.getRtaTarget());
        RtaClient rtaClient = (RtaClient)this.rtaClientFactory.get((Object)rtaType);
        if (log.isDebugEnabled()) {
            log.debug("RtaDispatcher send to rtaClient - {} - rtaConfig: {} ", (Object)rtaClient, (Object)JSONObject.toJSONString((Object)rtaConfig));
        }
        return rtaClient.isTarget(rtaRequest);
    }

    @Override
    public SourceType sourceType() {
        return SourceType.RTA_API;
    }
}

