/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.api.util.limiter;

import com.bxm.pangu.rta.api.util.limiter.DeleteExpiredHandler;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class DefaultDeleteExpiredHandler
implements DeleteExpiredHandler,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultDeleteExpiredHandler.class);
    private final BlockingQueue<QueueEntity> queue = new LinkedBlockingQueue<QueueEntity>(1000);
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("expire"));
    private final Updater updater;

    public DefaultDeleteExpiredHandler(Updater updater) {
        this.updater = updater;
        this.startHandleQueue();
    }

    @Override
    public void delete(KeyGenerator hashKey, String field) {
        if (!this.queue.offer(new QueueEntity(hashKey, field))) {
            log.warn("the queue was full.");
        }
    }

    public void destroy() {
        this.executor.shutdownNow();
    }

    private void startHandleQueue() {
        this.executor.execute(() -> {
            while (true) {
                try {
                    while (true) {
                        QueueEntity entity = this.queue.take();
                        KeyGenerator hashKey = entity.hashKey;
                        String field = entity.field;
                        this.updater.hremove(hashKey, new String[]{field});
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Deleted key hash {} field {}.", (Object)hashKey.generateKey(), (Object)field);
                    }
                }
                catch (Exception e) {
                    log.info("take: {}", (Object)e.getMessage());
                    continue;
                }
                break;
            }
        });
    }

    private static class QueueEntity {
        KeyGenerator hashKey;
        String field;

        private QueueEntity(KeyGenerator hashKey, String field) {
            this.hashKey = hashKey;
            this.field = field;
        }
    }
}

