/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.micrometer;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.micrometer.RtaClientMicroMeter;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class RtaClientMicroMeterAspect {
    private static final Logger log = LoggerFactory.getLogger(RtaClientMicroMeterAspect.class);
    private final RtaClientMicroMeter microMeter;

    public RtaClientMicroMeterAspect(RtaClientMicroMeter microMeter) {
        this.microMeter = microMeter;
    }

    @Pointcut(value="this(com.bxm.pangu.rta.common.RtaClient) && execution(* isTarget(..))")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof RtaClient)) {
            return point.proceed();
        }
        Object[] args = point.getArgs();
        RtaClient client = (RtaClient)target;
        long start = System.nanoTime();
        RtaType rtaType = client.getRtaType();
        try {
            Object is;
            Object o = point.proceed();
            if (o instanceof Boolean) {
                is = (Boolean)o;
                if (((Boolean)is).booleanValue()) {
                    this.microMeter.incrementSuccess(rtaType);
                } else {
                    this.microMeter.incrementFail(rtaType);
                }
            }
            is = o;
            return is;
        }
        catch (RtaRequestException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SocketTimeoutException) {
                this.microMeter.incrementReadException(rtaType);
            } else if (cause instanceof IOException) {
                this.microMeter.incrementConnectException(rtaType);
            } else {
                this.microMeter.incrementOtherException(rtaType);
            }
            throw e;
        }
        finally {
            this.microMeter.record(rtaType, start);
        }
    }
}

