package com.bxm.pangu.rta.common;

/**
 * RTA 类型
 *
 * @author allen
 * @date 2021-12-20
 * @since 1.0.0
 */
public enum RtaType {

    /**
     * For testing
     */
    Testing(0),

    /**
     * 淘宝
     */
    Taobao(1),

    /**
     * 快手
     */
    KuaiShou(2),

    /**
     * OneWay Agency
     */
    OneWay(3),

    /**
     * 麦晗
     */
    Myhayo(4),

    /**
     * 百度
     */
    Baidu(5),

    /**
     * 辉煌大航海
     */
    Hhdhh(6),

    /**
     * 西安鲸鱼
     */
    XiAnJingYu(7),

    /**
     * 个推
     */
    Getui(8),

    /**
     * 芒果联盟
     */
    Mango(9),

    /**
     * 腾讯视频
     */
    TencentVideo(10),

    /**
     * 滴滴
     */
    Didi(11),

    /**
     * 瑞狮网络
     */
    Vlion(12),

    /**
     * 硬核创世
     */
    Yhcs(13),

    /**
     * 知乎
     */
    Zhihu(14),

    /**
     * 百川
     */
    Baichuan(15),

    /**
     * 美团
     */
    Meituan(16),

    /**
     * 百度沉默
     */
    BaiduSilent(17),

    /**
     * 全民K歌
     */
    Kge(18),

    /**
     * 斗鱼
     */
    Douyu(19),

    /**
     * 淘宝活动
     */
    TaobaoActivity(20),

    /**
     * 汽车之家
     */
    Autohome(21),

    /**
     * uc
     */
    Uc(22),

    /**
     * 天眼查
     */
    TianYanCha(23),

    /**
     * 京东（金融）
     */
    Jd(24),

    /**
     * 高德
     */
    Amap(25),

    /**
     * 新义
     */
    Xinyi(26),

    /**
     * 个推天眼查
     */
    Gttyc(27);

    private final int type;

    RtaType(int type) {
        this.type = type;
    }

    public static RtaType of(int type) {
        for (RtaType value : values()) {
            if (type == value.getType()) {
                return value;
            }
        }
        return null;
    }

    public int getType() {
        return type;
    }
}
