package com.bxm.pangu.rta.common.autohome;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.JsonHelper;
import lombok.Data;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Optional;

/**
 * @author allen
 * @date 2022-05-20
 * @since 1.0
 */
public class AutohomeRtaClient extends AbstractHttpClientRtaClient {

    public AutohomeRtaClient(AutohomeRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String url = getProperties().getUrl();

        String channel = Optional.ofNullable(request.getParam())
                .orElse("JYM2022_SF");

        String id = request.getImei_md5();
        if (StringUtils.isBlank(id)) {
            id = request.getOaid_md5();
        }
        if (StringUtils.isBlank(id)) {
            id = request.getIdfa_md5();
        }
        if (StringUtils.isBlank(id)) {
            id = request.getAndroidid_md5();
        }
        if (StringUtils.isBlank(id)) {
            id = request.getIdfa_md5();
        }

        String finalUrl = UriComponentsBuilder.fromUriString(url)
                .replaceQueryParam("id", id)
                .replaceQueryParam("idkind", "2")
                .replaceQueryParam("channel", channel)
                .build()
                .toString();

        return new HttpGet(finalUrl);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return JsonHelper.convert(json, Response.class).isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Autohome;
    }

    @Data
    private static class Response {

        private String returncode;
        private boolean result;

        public boolean isTarget() {
            return StringUtils.equalsIgnoreCase(returncode, "0") && result;
        }
    }
}
