package com.bxm.pangu.rta.common.gttyc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.UUIDHelper;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.springframework.http.MediaType;

import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * 个推天眼查rta对接实现
 *
 * @author jingyu.li
 * @date 2022-09-06
 */
public class GttycRtaClient extends AbstractHttpClientRtaClient {

    private final GttycRtaProperties properties;

    public GttycRtaClient(GttycRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    /**
     * 根据天眼查提供的文档返回指定请求（POST）
     * @param request 请求对象
     */
    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = request.getParam();
        if (StringUtils.isBlank(param)) {
            throw new RtaRequestException("param");
        }
        String[] arr = StringUtils.splitPreserveAllTokens(param, "|");
        if (arr.length < 4) {
            throw new RtaRequestException("param must be {accessId}|{accessSecrectKey}|{deviceType}|{projectTaskList}");
        }

        String accessId = arr[0];
        String accessSecrectKey = arr[1];
        String deviceType = arr[2];
        String projectTaskList = arr[3];

        HttpPost post = new HttpPost(properties.getUrl()+accessId);

        String timeStamp = TypeHelper.castToString(System.currentTimeMillis());
        post.addHeader("timeStamp", timeStamp);
        post.addHeader("Content-Type", MediaType.APPLICATION_JSON_UTF8_VALUE);
        post.addHeader("token", DigestUtils.md5Hex(accessId + accessSecrectKey + timeStamp));

        GttycRequest gttycRequest = new GttycRequest();
        gttycRequest.setRequestId(UUIDHelper.generate());
        gttycRequest.setDeviceType(deviceType);
        gttycRequest.setDeviceId(request.getOaid_md5());

        JSONObject jsonObject = JSONObject.parseObject(projectTaskList);
        gttycRequest.setProjectTaskList(jsonObject);

        post.setEntity(new StringEntity(JsonHelper.convert(gttycRequest), StandardCharsets.UTF_8));

        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        GttycResponse response = JsonHelper.convert(json, GttycResponse.class);
        if (!response.isRequestOk()) {
            return false;
        }

        Map<String, String[]> data = response.getData();
        if (data.values().isEmpty()){
            return false;
        }

        JSONObject param = JSONObject.parseObject(request.getParam().split("|")[3]);

        //获取天眼查返回的key
        List<String> dataList = data.keySet().stream().collect(Collectors.toList());

        boolean returnBoolean = false;
        for (String id : dataList) {

            List<String> dataIds = Arrays.asList(data.get(id));//天眼查返回的id

            //根据返回的key获取param参数里面的任务id进行判断
            JSONArray paramArray = param.getJSONArray(id);//param传过来的id

            if (paramArray.isEmpty()){
                continue;
            }

            boolean result = paramArray.stream().anyMatch(new Predicate<Object>() {
                @Override
                public boolean test(Object o1) {
                    return dataIds.contains(o1);
                }
            });

            if (result){
                returnBoolean = true;
            }
        }

        return returnBoolean;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Gttyc;
    }
}
