package com.bxm.pangu.rta.common.xianjy;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

/**
 * 西南鲸鱼
 *
 * @author allen
 * @date 2021-11-19
 * @since 1.0
 */
public class XianjyRtaClient extends AbstractHttpClientRtaClient {

    private final XianjyRtaProperties xianjyRtaProperties;

    public XianjyRtaClient(XianjyRtaProperties properties) {
        super(properties);
        this.xianjyRtaProperties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String url = xianjyRtaProperties.getUrl();

        String param = request.getParam();
        String platform = xianjyRtaProperties.getDefaultPlatform();
        String channel = xianjyRtaProperties.getChannel();
        String itemTask = "";

        String[] arr = StringUtils.split(param, "|");
        if (ArrayUtils.isNotEmpty(arr)) {
            if (arr.length >= 1) {
                platform = arr[0];
            }
            if (arr.length >= 2) {
                channel = arr[1];
            }
            if (arr.length >= 3) {
                itemTask = arr[2];
            }
        }

        XianjyRequest.Device0 device0 = new XianjyRequest.Device0()
                .setImeiMd5(request.getImei_md5())
                .setIdfaMd5(request.getIdfa_md5())
                .setOaidMd5(request.getOaid_md5());

        XianjyRequest xianjyRequest = new XianjyRequest()
                .setChannel(channel)
                .setPlatform(platform)
                .setDevice(device0);
        if (StringUtils.isNotBlank(itemTask)) {
            xianjyRequest.setItemTask(itemTask);
        }

        HttpPost post = new HttpPost(url);
        post.setEntity(new ByteArrayEntity(JsonHelper.convert2bytes(xianjyRequest)));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return JsonHelper.convert(json, XianjyResponse.class).isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.XiAnJingYu;
    }
}
