/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.yhcs;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.yhcs.YhcsResponse;
import com.bxm.pangu.rta.common.yhcs.YhcsRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class YhcsRtaClient
extends AbstractHttpClientRtaClient {
    public YhcsRtaClient(YhcsRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        boolean flag;
        String url = this.getProperties().getUrl();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        boolean bl = flag = this.putIfNotBlank((MultiValueMap<String, String>)params, "imei_md5", request.getImei_md5()) || this.putIfNotBlank((MultiValueMap<String, String>)params, "oaid_md5", request.getOaid_md5());
        if (!flag) {
            throw new RtaRequestException("Empty device id.");
        }
        String param = request.getParam();
        if (StringUtils.isBlank((String)param)) {
            throw new IllegalArgumentException("param");
        }
        String[] arr = StringUtils.splitByWholeSeparator((String)param, (String)"|");
        if (arr.length < 2) {
            throw new IllegalArgumentException("param");
        }
        String key = arr[0];
        String uid = arr[1];
        params.set((Object)"key", (Object)key);
        params.set((Object)"uid", (Object)uid);
        String finalUrl = UriComponentsBuilder.fromUriString((String)url).replaceQueryParams((MultiValueMap)params).build().toString();
        return new HttpGet(finalUrl);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        YhcsResponse res = (YhcsResponse)JsonHelper.convert((String)json, YhcsResponse.class);
        return res.isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Yhcs;
    }

    private boolean putIfNotBlank(MultiValueMap<String, String> params, String name, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            params.set((Object)"dp", (Object)name);
            params.set((Object)"d", (Object)value);
            return true;
        }
        return false;
    }
}

