/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.amap;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.amap.AmapRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

public class AmapRtaClient
extends AbstractHttpClientRtaClient {
    public AmapRtaClient(AmapRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = request.getParam();
        String[] arr = StringUtils.split((String)param, (String)"|");
        if (arr.length < 2) {
            throw new RtaRequestException("param");
        }
        String url = this.getRequestUrl(arr[0]);
        Req req = new Req().setReqId(RandomStringUtils.randomAlphanumeric((int)8)).setRtaIdList(Lists.newArrayList((Object[])new String[]{arr[1]}));
        String imei = request.getImei();
        String imeiMd5 = request.getImei_md5();
        String oaid = request.getOaid();
        String oaidMd5 = request.getOaid_md5();
        String idfa = request.getIdfa();
        String idfaMd5 = request.getIdfa_md5();
        if (StringUtils.isNotBlank((String)imei)) {
            req.setDidType("IMEI").setDids(Lists.newArrayList((Object[])new String[]{imei})).setDidSecure("NOMAL");
        } else if (StringUtils.isNotBlank((String)imeiMd5)) {
            req.setDidType("IMEI").setDids(Lists.newArrayList((Object[])new String[]{imeiMd5})).setDidSecure("MD5");
        } else if (StringUtils.isNotBlank((String)oaid)) {
            req.setDidType("OAID").setDids(Lists.newArrayList((Object[])new String[]{oaid})).setDidSecure("NOMAL");
        } else if (StringUtils.isNotBlank((String)oaidMd5)) {
            req.setDidType("OAID").setDids(Lists.newArrayList((Object[])new String[]{oaidMd5})).setDidSecure("MD5");
        } else if (StringUtils.isNotBlank((String)idfa)) {
            req.setDidType("IDFA").setDids(Lists.newArrayList((Object[])new String[]{idfa})).setDidSecure("NOMAL");
        } else if (StringUtils.isNotBlank((String)idfaMd5)) {
            req.setDidType("IDFA").setDids(Lists.newArrayList((Object[])new String[]{idfaMd5})).setDidSecure("MD5");
        } else {
            throw new RtaRequestException("Unsupported device id");
        }
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        post.setEntity((HttpEntity)new ByteArrayEntity(JsonHelper.convert2bytes((Object)req)));
        return post;
    }

    private String getRequestUrl(String channel) {
        String url = this.getProperties().getUrl();
        url = StringUtils.endsWith((String)url, (String)"/") ? url + channel : url + "/" + channel;
        return url;
    }

    @Override
    protected boolean isTarget(final RtaRequest request, String json) {
        Res res = (Res)JsonHelper.convert((String)json, Res.class);
        if (Objects.isNull(res)) {
            return false;
        }
        if (!StringUtils.equals((String)"0", (String)res.getResCode())) {
            return false;
        }
        String param = request.getParam();
        String[] arr = StringUtils.split((String)param, (String)"|");
        if (arr.length < 2) {
            throw new RtaRequestException("param");
        }
        final String expectRtaId = arr[1];
        try {
            return Optional.of(res).map(new Function<Res, List<ResRes>>(){

                @Override
                public List<ResRes> apply(Res res) {
                    return res.getResult();
                }
            }).map(new Function<List<ResRes>, Boolean>(){

                @Override
                public Boolean apply(List<ResRes> resRes) {
                    return resRes.stream().anyMatch(new Predicate<ResRes>(){

                        @Override
                        public boolean test(ResRes resRes) {
                            List<String> dids = resRes.getDids();
                            if (CollectionUtils.isEmpty(dids)) {
                                return false;
                            }
                            boolean hitDeviceId = dids.contains(request.getImei()) || dids.contains(request.getImei_md5()) || dids.contains(request.getOaid()) || dids.contains(request.getOaid_md5()) || dids.contains(request.getIdfa()) || dids.contains(request.getIdfa_md5());
                            boolean hitRtaId = StringUtils.equals((String)expectRtaId, (String)resRes.getRtaId());
                            return hitDeviceId && hitRtaId;
                        }
                    });
                }
            }).orElse(false);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Amap;
    }

    private static class ResRes {
        private String rtaId;
        private List<String> dids;

        public String getRtaId() {
            return this.rtaId;
        }

        public List<String> getDids() {
            return this.dids;
        }

        public void setRtaId(String rtaId) {
            this.rtaId = rtaId;
        }

        public void setDids(List<String> dids) {
            this.dids = dids;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResRes)) {
                return false;
            }
            ResRes other = (ResRes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$rtaId = this.getRtaId();
            String other$rtaId = other.getRtaId();
            if (this$rtaId == null ? other$rtaId != null : !this$rtaId.equals(other$rtaId)) {
                return false;
            }
            List<String> this$dids = this.getDids();
            List<String> other$dids = other.getDids();
            return !(this$dids == null ? other$dids != null : !((Object)this$dids).equals(other$dids));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResRes;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $rtaId = this.getRtaId();
            result = result * 59 + ($rtaId == null ? 43 : $rtaId.hashCode());
            List<String> $dids = this.getDids();
            result = result * 59 + ($dids == null ? 43 : ((Object)$dids).hashCode());
            return result;
        }

        public String toString() {
            return "AmapRtaClient.ResRes(rtaId=" + this.getRtaId() + ", dids=" + this.getDids() + ")";
        }
    }

    private static class Res {
        private String resCode;
        private List<ResRes> result;

        public String getResCode() {
            return this.resCode;
        }

        public List<ResRes> getResult() {
            return this.result;
        }

        public void setResCode(String resCode) {
            this.resCode = resCode;
        }

        public void setResult(List<ResRes> result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Res)) {
                return false;
            }
            Res other = (Res)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$resCode = this.getResCode();
            String other$resCode = other.getResCode();
            if (this$resCode == null ? other$resCode != null : !this$resCode.equals(other$resCode)) {
                return false;
            }
            List<ResRes> this$result = this.getResult();
            List<ResRes> other$result = other.getResult();
            return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Res;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $resCode = this.getResCode();
            result = result * 59 + ($resCode == null ? 43 : $resCode.hashCode());
            List<ResRes> $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            return result;
        }

        public String toString() {
            return "AmapRtaClient.Res(resCode=" + this.getResCode() + ", result=" + this.getResult() + ")";
        }
    }

    private static class Req {
        public static final String DID_TYPE_IMEI = "IMEI";
        public static final String DID_TYPE_OAID = "OAID";
        public static final String DID_TYPE_IDFA = "IDFA";
        public static final String DID_SECURE_MD5 = "MD5";
        public static final String DID_SECURE_NOMAL = "NOMAL";
        private String reqId;
        private List<String> dids;
        private String didType;
        private String didSecure;
        private List<String> rtaIdList;

        public String getReqId() {
            return this.reqId;
        }

        public List<String> getDids() {
            return this.dids;
        }

        public String getDidType() {
            return this.didType;
        }

        public String getDidSecure() {
            return this.didSecure;
        }

        public List<String> getRtaIdList() {
            return this.rtaIdList;
        }

        public Req setReqId(String reqId) {
            this.reqId = reqId;
            return this;
        }

        public Req setDids(List<String> dids) {
            this.dids = dids;
            return this;
        }

        public Req setDidType(String didType) {
            this.didType = didType;
            return this;
        }

        public Req setDidSecure(String didSecure) {
            this.didSecure = didSecure;
            return this;
        }

        public Req setRtaIdList(List<String> rtaIdList) {
            this.rtaIdList = rtaIdList;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Req)) {
                return false;
            }
            Req other = (Req)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$reqId = this.getReqId();
            String other$reqId = other.getReqId();
            if (this$reqId == null ? other$reqId != null : !this$reqId.equals(other$reqId)) {
                return false;
            }
            List<String> this$dids = this.getDids();
            List<String> other$dids = other.getDids();
            if (this$dids == null ? other$dids != null : !((Object)this$dids).equals(other$dids)) {
                return false;
            }
            String this$didType = this.getDidType();
            String other$didType = other.getDidType();
            if (this$didType == null ? other$didType != null : !this$didType.equals(other$didType)) {
                return false;
            }
            String this$didSecure = this.getDidSecure();
            String other$didSecure = other.getDidSecure();
            if (this$didSecure == null ? other$didSecure != null : !this$didSecure.equals(other$didSecure)) {
                return false;
            }
            List<String> this$rtaIdList = this.getRtaIdList();
            List<String> other$rtaIdList = other.getRtaIdList();
            return !(this$rtaIdList == null ? other$rtaIdList != null : !((Object)this$rtaIdList).equals(other$rtaIdList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Req;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $reqId = this.getReqId();
            result = result * 59 + ($reqId == null ? 43 : $reqId.hashCode());
            List<String> $dids = this.getDids();
            result = result * 59 + ($dids == null ? 43 : ((Object)$dids).hashCode());
            String $didType = this.getDidType();
            result = result * 59 + ($didType == null ? 43 : $didType.hashCode());
            String $didSecure = this.getDidSecure();
            result = result * 59 + ($didSecure == null ? 43 : $didSecure.hashCode());
            List<String> $rtaIdList = this.getRtaIdList();
            result = result * 59 + ($rtaIdList == null ? 43 : ((Object)$rtaIdList).hashCode());
            return result;
        }

        public String toString() {
            return "AmapRtaClient.Req(reqId=" + this.getReqId() + ", dids=" + this.getDids() + ", didType=" + this.getDidType() + ", didSecure=" + this.getDidSecure() + ", rtaIdList=" + this.getRtaIdList() + ")";
        }
    }
}

