/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.autoconfigure;

import com.bxm.pangu.rta.common.CachingRedisProperties;
import com.bxm.pangu.rta.common.core.EventAspect;
import com.bxm.pangu.rta.common.core.RequestComputeTimesEventListener;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.message.dingding.DingDingMessageSender;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;

public class EventAutoConfiguration {
    private final CachingRedisProperties properties;

    public EventAutoConfiguration(CachingRedisProperties properties) {
        this.properties = properties;
    }

    @Bean(name={"rtaMessageSender"})
    public MessageSender rtaMessageSender() {
        return new DingDingMessageSender(this.properties.getDingTalkUrl());
    }

    @Bean
    public EventAspect eventAspect(EventPark eventPark) {
        return new EventAspect(eventPark);
    }

    @Bean
    public RequestComputeTimesEventListener requestComputeTimesEventListener(@Qualifier(value="cachingCounter") Counter counter, @Qualifier(value="rtaMessageSender") MessageSender rtaMessageSender) {
        return new RequestComputeTimesEventListener(counter, rtaMessageSender);
    }
}

