/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.baidu_silent;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.baidu_silent.BaiduSilentRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class BaiduSilentRtaClient
extends AbstractHttpClientRtaClient {
    private static final Logger log = LoggerFactory.getLogger(BaiduSilentRtaClient.class);
    private final BaiduSilentRtaProperties properties;

    public BaiduSilentRtaClient(BaiduSilentRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String url = this.properties.getUrl();
        String param = request.getParam();
        if (StringUtils.isBlank((String)param)) {
            throw new RtaRequestException("param");
        }
        String[] arr = StringUtils.split((String)param, (String)"|");
        if (arr.length < 2) {
            throw new RtaRequestException("param must be {channel_name}|{secretKey}");
        }
        TreeMap<String, String> dp = new TreeMap<String, String>();
        String imeiMd5 = request.getImei_md5();
        if (StringUtils.isBlank((String)imeiMd5)) {
            throw new RtaRequestException("imeiMd5 is blank!");
        }
        dp.put("imeis", imeiMd5);
        dp.put("channel_name", arr[0]);
        dp.put("request_time", String.valueOf(System.currentTimeMillis()));
        StringBuilder s = new StringBuilder();
        dp.forEach((key, value) -> s.append((String)key).append("=").append((String)value));
        s.append(arr[1]);
        dp.put("sign", DigestUtils.md5Hex((String)s.toString()));
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        dp.forEach((arg_0, arg_1) -> ((MultiValueMap)params).add(arg_0, arg_1));
        String finalUrl = UriComponentsBuilder.fromUriString((String)url).replaceQueryParams((MultiValueMap)params).build().toString();
        return new HttpGet(finalUrl);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)json);
        }
        return ((Res)JsonHelper.convert((String)json, Res.class)).isTarget(request.getImei_md5());
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.BaiduSilent;
    }

    static class Res {
        private String errno;
        private List<String> data;
        private String msg;

        public boolean isTarget(String imeiMd5) {
            return StringUtils.equals((String)"0", (String)this.errno) && CollectionUtils.isNotEmpty(this.data) && this.data.contains(imeiMd5);
        }

        public String getErrno() {
            return this.errno;
        }

        public List<String> getData() {
            return this.data;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setErrno(String errno) {
            this.errno = errno;
        }

        public void setData(List<String> data) {
            this.data = data;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Res)) {
                return false;
            }
            Res other = (Res)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$errno = this.getErrno();
            String other$errno = other.getErrno();
            if (this$errno == null ? other$errno != null : !this$errno.equals(other$errno)) {
                return false;
            }
            List<String> this$data = this.getData();
            List<String> other$data = other.getData();
            if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Res;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $errno = this.getErrno();
            result = result * 59 + ($errno == null ? 43 : $errno.hashCode());
            List<String> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            return result;
        }

        public String toString() {
            return "BaiduSilentRtaClient.Res(errno=" + this.getErrno() + ", data=" + this.getData() + ", msg=" + this.getMsg() + ")";
        }
    }
}

