/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.changba;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.changba.ChangbaRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class ChangbaRtaClient
extends AbstractHttpClientRtaClient {
    private final ChangbaRtaProperties properties;
    private static final String OS_ANDROID = "0";
    private static final String OS_IOS = "1";

    public ChangbaRtaClient(ChangbaRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = request.getParam();
        if (StringUtils.isBlank((String)param)) {
            throw new IllegalArgumentException("param");
        }
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"ac", (Object)"rtatrack");
        params.add((Object)"check_ids", (Object)param);
        params.add((Object)"imei_md5", (Object)Optional.ofNullable(request.getImei_md5()).orElse(""));
        params.add((Object)"oaid_md5", (Object)Optional.ofNullable(request.getOaid_md5()).orElse(""));
        params.add((Object)"idfa_md5", (Object)Optional.ofNullable(request.getIdfa_md5()).orElse(""));
        params.add((Object)"android_id_md5", (Object)Optional.ofNullable(request.getAndroidid_md5()).orElse(""));
        if (StringUtils.isNotBlank((String)request.getOs())) {
            params.add((Object)"os", (Object)("android".equals(request.getOs()) ? OS_ANDROID : ("ios".equals(request.getOs()) ? OS_IOS : "")));
        } else {
            params.add((Object)"os", (Object)(StringUtils.isNotBlank((String)request.getIdfa_md5()) ? OS_IOS : OS_ANDROID));
        }
        String url = UriComponentsBuilder.fromUriString((String)this.properties.getUrl()).replaceQueryParams((MultiValueMap)params).build().toString();
        return new HttpGet(url);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        Res res = (Res)JsonHelper.convert((String)json, Res.class);
        if (Objects.isNull(res)) {
            return false;
        }
        if (!StringUtils.equals((String)OS_ANDROID, (String)res.getCode())) {
            return false;
        }
        String param = request.getParam();
        if (StringUtils.isBlank((String)param)) {
            throw new RtaRequestException("param");
        }
        return StringUtils.isNotBlank((String)res.getDeliver_ids());
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.ChangBa;
    }

    private static class Res {
        private String Code;
        private String Message;
        private String Deliver_ids;
        private String Filter_ids;

        public String getCode() {
            return this.Code;
        }

        public String getMessage() {
            return this.Message;
        }

        public String getDeliver_ids() {
            return this.Deliver_ids;
        }

        public String getFilter_ids() {
            return this.Filter_ids;
        }

        public void setCode(String Code) {
            this.Code = Code;
        }

        public void setMessage(String Message2) {
            this.Message = Message2;
        }

        public void setDeliver_ids(String Deliver_ids) {
            this.Deliver_ids = Deliver_ids;
        }

        public void setFilter_ids(String Filter_ids) {
            this.Filter_ids = Filter_ids;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Res)) {
                return false;
            }
            Res other = (Res)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$Code = this.getCode();
            String other$Code = other.getCode();
            if (this$Code == null ? other$Code != null : !this$Code.equals(other$Code)) {
                return false;
            }
            String this$Message = this.getMessage();
            String other$Message = other.getMessage();
            if (this$Message == null ? other$Message != null : !this$Message.equals(other$Message)) {
                return false;
            }
            String this$Deliver_ids = this.getDeliver_ids();
            String other$Deliver_ids = other.getDeliver_ids();
            if (this$Deliver_ids == null ? other$Deliver_ids != null : !this$Deliver_ids.equals(other$Deliver_ids)) {
                return false;
            }
            String this$Filter_ids = this.getFilter_ids();
            String other$Filter_ids = other.getFilter_ids();
            return !(this$Filter_ids == null ? other$Filter_ids != null : !this$Filter_ids.equals(other$Filter_ids));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Res;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $Code = this.getCode();
            result = result * 59 + ($Code == null ? 43 : $Code.hashCode());
            String $Message = this.getMessage();
            result = result * 59 + ($Message == null ? 43 : $Message.hashCode());
            String $Deliver_ids = this.getDeliver_ids();
            result = result * 59 + ($Deliver_ids == null ? 43 : $Deliver_ids.hashCode());
            String $Filter_ids = this.getFilter_ids();
            result = result * 59 + ($Filter_ids == null ? 43 : $Filter_ids.hashCode());
            return result;
        }

        public String toString() {
            return "ChangbaRtaClient.Res(Code=" + this.getCode() + ", Message=" + this.getMessage() + ", Deliver_ids=" + this.getDeliver_ids() + ", Filter_ids=" + this.getFilter_ids() + ")";
        }
    }
}

