/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.douyu;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.douyu.DouyuRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

public class DouyuRtaClient
extends AbstractHttpClientRtaClient {
    public DouyuRtaClient(DouyuRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        HttpPost post = new HttpPost(this.getProperties().getUrl());
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        String oaidMd5 = request.getOaid_md5();
        if (StringUtils.isBlank((String)oaidMd5)) {
            throw new RtaRequestException("Only supported oaid_md5");
        }
        ArrayList uids = Lists.newArrayList((Object[])new String[]{oaidMd5});
        String utype = "oaid";
        String encrypttype = "md5";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uids", uids);
        map.put("utype", utype);
        map.put("encrypttype", encrypttype);
        post.setEntity((HttpEntity)new ByteArrayEntity(JsonHelper.convert2bytes(map)));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return ((Res)JsonHelper.convert((String)json, Res.class)).isTarget(request);
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Douyu;
    }

    private static class Res {
        private String code;
        private String msg;
        private List<String> uids;

        public boolean isTarget(RtaRequest request) {
            return StringUtils.equals((String)"1", (String)this.code) && CollectionUtils.isNotEmpty(this.uids) && this.uids.contains(request.getOaid_md5());
        }

        public String getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public List<String> getUids() {
            return this.uids;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setUids(List<String> uids) {
            this.uids = uids;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Res)) {
                return false;
            }
            Res other = (Res)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                return false;
            }
            List<String> this$uids = this.getUids();
            List<String> other$uids = other.getUids();
            return !(this$uids == null ? other$uids != null : !((Object)this$uids).equals(other$uids));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Res;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            List<String> $uids = this.getUids();
            result = result * 59 + ($uids == null ? 43 : ((Object)$uids).hashCode());
            return result;
        }

        public String toString() {
            return "DouyuRtaClient.Res(code=" + this.getCode() + ", msg=" + this.getMsg() + ", uids=" + this.getUids() + ")";
        }
    }
}

