/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.dsfds;

import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.dsfds.DsfdsRtaProperties;
import com.bxm.pangu.rta.common.dsfds.DsfdsRtaRequest;
import com.bxm.warcar.utils.JsonHelper;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

public class DsfdsRtaClient
extends AbstractHttpClientRtaClient {
    private final DsfdsRtaProperties properties;

    public DsfdsRtaClient(DsfdsRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = request.getParam();
        if (StringUtils.isBlank((String)param)) {
            throw new RtaRequestException("The parameter format is 'id'");
        }
        DsfdsRtaRequest dsfdsRtaRequest = new DsfdsRtaRequest();
        dsfdsRtaRequest.setId(param);
        dsfdsRtaRequest.setChannel(this.properties.getChannel());
        ArrayList<String> dmIds = new ArrayList<String>();
        String imeiMd5 = request.getImei_md5();
        if (StringUtils.isNotBlank((String)imeiMd5)) {
            dmIds.add("D10");
            dsfdsRtaRequest.setDm_ids(dmIds);
            dsfdsRtaRequest.setDevice_type(3);
            dsfdsRtaRequest.setDevice_num(imeiMd5);
        }
        String oaidMd5 = request.getOaid_md5();
        if (StringUtils.isBlank((String)dsfdsRtaRequest.getDevice_num()) && StringUtils.isNotBlank((String)oaidMd5)) {
            dmIds.add("D11");
            dsfdsRtaRequest.setDm_ids(dmIds);
            dsfdsRtaRequest.setDevice_type(5);
            dsfdsRtaRequest.setDevice_num(oaidMd5);
        }
        if (StringUtils.isBlank((String)dsfdsRtaRequest.getDevice_num())) {
            throw new RtaRequestException("deviceNum is empty");
        }
        HttpPost httpPost = new HttpPost(this.properties.getUrl());
        httpPost.addHeader("Content-Type", "application/json;charset=UTF-8");
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(JsonHelper.convert2bytes((Object)dsfdsRtaRequest)));
        return httpPost;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        JSONObject response = JSONObject.parseObject((String)json);
        int code = (Integer)response.get((Object)"code");
        if (code != 0) {
            return false;
        }
        JSONObject dms = response.getJSONObject("dms");
        if (dms == null) {
            return false;
        }
        Integer d10 = dms.getInteger("D10");
        Integer d11 = dms.getInteger("D11");
        return d10 != null && d10 == 0 || d11 != null && d11 == 0;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.dsfds;
    }
}

