/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.dyfx;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.dyfx.DyfxRtaProperties;
import com.bxm.pangu.rta.common.dyfx.DyfxRtaResponse;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

public class DyfxRtaClient
extends AbstractHttpClientRtaClient {
    private final DyfxRtaProperties properties;

    public DyfxRtaClient(DyfxRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        Integer deviceFingerprintType = null;
        String deviceFingerprintId = null;
        Boolean md5 = false;
        String idfa = request.getIdfa();
        String idfaMd5 = request.getIdfa_md5();
        if (StringUtils.isNotBlank((String)idfa) || StringUtils.isNotBlank((String)idfaMd5)) {
            deviceFingerprintType = 1;
            if (StringUtils.isNotBlank((String)idfa)) {
                deviceFingerprintId = idfa;
            } else {
                deviceFingerprintId = idfaMd5.toUpperCase();
                md5 = true;
            }
        }
        String imei = request.getImei();
        String imeiMd5 = request.getImei_md5();
        if (StringUtils.isBlank((String)deviceFingerprintId) && (StringUtils.isNotBlank((String)imei) || StringUtils.isNotBlank((String)imeiMd5))) {
            deviceFingerprintType = 2;
            if (StringUtils.isNotBlank((String)imei)) {
                deviceFingerprintId = imei;
            } else {
                deviceFingerprintId = imeiMd5.toUpperCase();
                md5 = true;
            }
        }
        String androidid = request.getAndroidid();
        String androididMd5 = request.getAndroidid_md5();
        if (StringUtils.isBlank((String)deviceFingerprintId) && (StringUtils.isNotBlank((String)androidid) || StringUtils.isNotBlank((String)androididMd5))) {
            deviceFingerprintType = 3;
            if (StringUtils.isNotBlank((String)androidid)) {
                deviceFingerprintId = androidid;
            } else {
                deviceFingerprintId = androididMd5.toUpperCase();
                md5 = true;
            }
        }
        String gaid = request.getGaid();
        String gaidMd5 = request.getGaid_md5();
        if (StringUtils.isBlank((String)deviceFingerprintId) && (StringUtils.isNotBlank((String)gaid) || StringUtils.isNotBlank((String)gaidMd5))) {
            deviceFingerprintType = 4;
            if (StringUtils.isNotBlank((String)gaid)) {
                deviceFingerprintId = gaid;
            } else {
                deviceFingerprintId = gaidMd5.toUpperCase();
                md5 = true;
            }
        }
        String oaid = request.getOaid();
        String oaidMd5 = request.getOaid_md5();
        if (StringUtils.isBlank((String)deviceFingerprintId) && (StringUtils.isNotBlank((String)oaid) || StringUtils.isNotBlank((String)oaidMd5))) {
            deviceFingerprintType = 5;
            if (StringUtils.isNotBlank((String)oaid)) {
                deviceFingerprintId = oaid;
            } else {
                deviceFingerprintId = oaidMd5.toUpperCase();
                md5 = true;
            }
        }
        if (StringUtils.isBlank((String)deviceFingerprintId)) {
            throw new RtaRequestException("device is not empty!");
        }
        HashMap dyfxRequestMap = Maps.newHashMap();
        dyfxRequestMap.put("deviceFingerprintId", deviceFingerprintId);
        dyfxRequestMap.put("deviceFingerprintType", deviceFingerprintType);
        dyfxRequestMap.put("md5", md5);
        HttpPost httpPost = new HttpPost(this.properties.getUrl());
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(JsonHelper.convert2bytes((Object)dyfxRequestMap)));
        return httpPost;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        DyfxRtaResponse response = (DyfxRtaResponse)JsonHelper.convert((String)json, DyfxRtaResponse.class);
        if (!response.isSuccess().booleanValue()) {
            return false;
        }
        return response.getData() != null && response.getData().getPotentialCustomer() != false;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.dyfx;
    }
}

