/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.kge;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.kge.KgeRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KgeRtaClient
extends AbstractHttpClientRtaClient {
    private static final Logger log = LoggerFactory.getLogger(KgeRtaClient.class);

    public KgeRtaClient(KgeRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String url = this.getProperties().getUrl();
        HttpPost post = new HttpPost(url);
        String param = request.getParam();
        if (StringUtils.isBlank((String)param)) {
            throw new NullPointerException("param");
        }
        String[] arr = StringUtils.split((String)param, (String)"|");
        if (arr.length < 3) {
            throw new IllegalArgumentException("param");
        }
        String companySource = arr[0];
        String companyId = arr[1];
        int adId = NumberUtils.toInt((String)arr[2]);
        HashMap body = Maps.newHashMap();
        body.put("company_source", companySource);
        body.put("company_id", NumberUtils.toInt((String)companyId));
        body.put("platform", StringUtils.equals((String)request.getOs(), (String)"android") ? 1 : 2);
        body.put("idfa_md5", request.getIdfa_md5());
        body.put("imei_md5", request.getImei_md5());
        body.put("oaid_md5", request.getOaid_md5());
        body.put("android_id_md5", request.getAndroidid_md5());
        body.put("ad_ids", new int[]{adId});
        post.setEntity((HttpEntity)new ByteArrayEntity(JsonHelper.convert2bytes((Object)body)));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)json);
        }
        return ((KgeResponse)JsonHelper.convert((String)json, KgeResponse.class)).isTarget(request);
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Kge;
    }

    private static class KgeResponse {
        private int code = -1;
        private String msg;
        private List<String> deliver_ids;
        private List<String> filter_ids;

        public boolean isTarget(RtaRequest request) {
            if (this.code != 0) {
                return false;
            }
            if (CollectionUtils.isEmpty(this.deliver_ids)) {
                return false;
            }
            String[] arr = StringUtils.split((String)request.getParam(), (String)"|");
            if (arr.length < 3) {
                throw new IllegalArgumentException("param");
            }
            return this.deliver_ids.stream().anyMatch(e -> StringUtils.equals((String)e, (String)arr[2]));
        }

        public int getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public List<String> getDeliver_ids() {
            return this.deliver_ids;
        }

        public List<String> getFilter_ids() {
            return this.filter_ids;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setDeliver_ids(List<String> deliver_ids) {
            this.deliver_ids = deliver_ids;
        }

        public void setFilter_ids(List<String> filter_ids) {
            this.filter_ids = filter_ids;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KgeResponse)) {
                return false;
            }
            KgeResponse other = (KgeResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                return false;
            }
            List<String> this$deliver_ids = this.getDeliver_ids();
            List<String> other$deliver_ids = other.getDeliver_ids();
            if (this$deliver_ids == null ? other$deliver_ids != null : !((Object)this$deliver_ids).equals(other$deliver_ids)) {
                return false;
            }
            List<String> this$filter_ids = this.getFilter_ids();
            List<String> other$filter_ids = other.getFilter_ids();
            return !(this$filter_ids == null ? other$filter_ids != null : !((Object)this$filter_ids).equals(other$filter_ids));
        }

        protected boolean canEqual(Object other) {
            return other instanceof KgeResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            List<String> $deliver_ids = this.getDeliver_ids();
            result = result * 59 + ($deliver_ids == null ? 43 : ((Object)$deliver_ids).hashCode());
            List<String> $filter_ids = this.getFilter_ids();
            result = result * 59 + ($filter_ids == null ? 43 : ((Object)$filter_ids).hashCode());
            return result;
        }

        public String toString() {
            return "KgeRtaClient.KgeResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ", deliver_ids=" + this.getDeliver_ids() + ", filter_ids=" + this.getFilter_ids() + ")";
        }
    }
}

