/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.lazada;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaClientProperties;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.lazada.LazadaRtaProperties;
import com.bxm.pangu.rta.common.utils.HttpClientUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class LazadaRtaClient
implements RtaClient {
    private static final Logger log = LoggerFactory.getLogger(LazadaRtaClient.class);
    private final HttpClient httpClient;
    private final LazadaRtaProperties properties;

    public LazadaRtaClient(LazadaRtaProperties properties) {
        this.properties = properties;
        this.httpClient = HttpClientUtils.createHttpClient(properties.getMaxTotal(), properties.getDefaultMaxPerRoute(), properties.getConnectionRequestTimeout(), properties.getConnectTimeout(), properties.getSocketTimeout());
    }

    @Override
    public boolean isTarget(RtaRequest request, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        String body = null;
        HttpRequestBase requestBase = null;
        RtaType rtaType = this.getRtaType();
        try {
            boolean isTarget;
            HttpResponse response;
            int statusCode;
            requestBase = this.create(request);
            if (log.isDebugEnabled()) {
                log.debug("request: {}", (Object)requestBase.getURI());
            }
            if ((statusCode = (response = this.httpClient.execute((HttpUriRequest)requestBase)).getStatusLine().getStatusCode()) != 200) {
                log.warn("{} - statusCode: {}", (Object)rtaType, (Object)statusCode);
            }
            body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (log.isDebugEnabled()) {
                log.debug("response: {}", (Object)body);
            }
            boolean bl = isTarget = this.isTarget(request, body, feedback);
            return bl;
        }
        catch (JSONException e) {
            if (this.properties.isPrintException()) {
                log.warn("{} - {} - {}", new Object[]{rtaType, e.getMessage(), body});
            }
            throw new RtaRequestException(e);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("{} - {}", (Object)rtaType, (Object)e.getMessage());
            }
            throw new RtaRequestException(e);
        }
        finally {
            if (Objects.nonNull(requestBase) && !requestBase.isAborted()) {
                requestBase.abort();
            }
        }
    }

    private HttpRequestBase create(RtaRequest request) {
        String param = request.getParam();
        if (StringUtils.isBlank((CharSequence)param)) {
            throw new RtaRequestException("param cannot be empty");
        }
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"app_key", (Object)this.properties.getAppKey());
        params.add((Object)"timestamp", (Object)String.valueOf(System.currentTimeMillis()));
        params.add((Object)"sign_method", (Object)"hmac-sha256");
        if (StringUtils.isNotBlank((CharSequence)request.getOaid())) {
            params.add((Object)"oaid", (Object)request.getOaid());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getOaid_md5())) {
            params.add((Object)"oaid_md5", (Object)request.getOaid_md5());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getGaid())) {
            params.add((Object)"gaid", (Object)request.getGaid());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getGaid_md5())) {
            params.add((Object)"gaid_md5", (Object)request.getGaid_md5());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getIdfa())) {
            params.add((Object)"idfa", (Object)request.getIdfa());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getIdfa_md5())) {
            params.add((Object)"idfa_md5", (Object)request.getIdfa_md5());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getImei())) {
            params.add((Object)"imei", (Object)request.getImei());
        }
        JSONObject jsonObject = JSONObject.parseObject((String)this.properties.getUrlJson());
        String campaignIdList = JSONObject.toJSONString((Object)jsonObject.keySet());
        params.add((Object)"campaign_id_list", (Object)campaignIdList);
        params.add((Object)"country", (Object)request.getCountryCode());
        String memberId = JSONObject.parseObject((String)param).getString(request.getCountryCode());
        params.add((Object)"member_id", (Object)memberId);
        String sign = null;
        try {
            sign = LazadaRtaClient.signApiRequest((MultiValueMap<String, String>)params, null, this.properties.getAppSecret(), this.properties.getApiName());
        }
        catch (IOException e) {
            throw new RtaRequestException("sign error " + e.getMessage());
        }
        params.remove((Object)"campaign_id_list");
        params.add((Object)"campaign_id_list", (Object)URLEncoder.encode(campaignIdList));
        params.add((Object)"sign", (Object)sign);
        String url = this.properties.getUrl() + this.properties.getApiName();
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)url).replaceQueryParams((MultiValueMap)params);
        return new HttpGet(uriComponentsBuilder.build().toString());
    }

    private boolean isTarget(RtaRequest request, String json, Consumer<Map<Object, Object>> feedback) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return false;
        }
        JSONObject response = JSONObject.parseObject((String)json);
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)response.getString("code"))) {
            return false;
        }
        JSONObject data = response.getJSONObject("data");
        JSONArray targetList = data.getJSONArray("target_list");
        if (targetList.isEmpty()) {
            return false;
        }
        JSONObject urlJson = JSONObject.parseObject((String)this.properties.getUrlJson());
        for (int i = 0; i < targetList.size(); ++i) {
            JSONObject jsonObject = targetList.getJSONObject(i);
            if (!jsonObject.getBoolean("target").booleanValue()) continue;
            String campaignId = jsonObject.getString("campaign_id");
            JSONArray urlJsonArray = urlJson.getJSONArray(campaignId);
            if (!Objects.nonNull(feedback)) continue;
            HashMap res = Maps.newHashMap();
            res.put("token", data.getString("token"));
            res.put("deepLinkUrl", urlJsonArray.getString(0));
            res.put("clickUrl", urlJsonArray.getString(1));
            feedback.accept(res);
            return true;
        }
        return false;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Lazada;
    }

    @Override
    public RtaClientProperties getProperties() {
        return this.properties;
    }

    public static String signApiRequest(MultiValueMap<String, String> params, String body, String appSecret, String apiName) throws IOException {
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        query.append(apiName);
        for (Object key : keys) {
            String value = (String)params.getFirst(key);
            if (!StringUtils.isNotBlank((CharSequence)key) || !StringUtils.isNotBlank((CharSequence)value)) continue;
            query.append((String)key).append(value);
        }
        if (body != null) {
            query.append(body);
        }
        byte[] bytes = LazadaRtaClient.encryptHMACSHA256(query.toString(), appSecret);
        return LazadaRtaClient.byte2hex(bytes);
    }

    private static byte[] encryptHMACSHA256(String data, String secret) throws IOException {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA256");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes("UTF-8"));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    public static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }
}

