/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.taobao_vegas;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaClientProperties;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.taobao_vegas.TaobaoVegasRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.SafeMapHelper;
import com.google.common.collect.Maps;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.request.TbkDgVegasSendStatusRequest;
import com.taobao.api.response.TbkDgVegasSendStatusResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaobaoVegasRtaClient
implements RtaClient {
    private static final Logger log = LoggerFactory.getLogger(TaobaoVegasRtaClient.class);
    private final TaobaoVegasRtaProperties properties;
    private final ConcurrentHashMap<String, TaobaoClient> clients = new ConcurrentHashMap();

    public TaobaoVegasRtaClient(TaobaoVegasRtaProperties properties) {
        this.properties = properties;
        TaobaoLogger.setNeedEnableLogger((boolean)properties.isNeedEnableLogger());
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.TaobaoVegas;
    }

    @Override
    public RtaClientProperties getProperties() {
        return this.properties;
    }

    private TaobaoClient getClient(String appKey, String appSecret) {
        return (TaobaoClient)SafeMapHelper.get(this.clients, (Object)appKey, () -> {
            String url = this.properties.getUrl();
            int connectTimeout = this.properties.getConnectTimeout();
            int socketTimeout = this.properties.getSocketTimeout();
            return new DefaultTaobaoClient(url, appKey, appSecret, "json", connectTimeout, socketTimeout);
        });
    }

    @Override
    public boolean isTarget(RtaRequest request, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        String param = request.getParam();
        Object[] arr = StringUtils.splitPreserveAllTokens((String)param, (String)"|");
        if (ArrayUtils.isEmpty((Object[])arr) || arr.length < 6) {
            throw new RtaRequestException("param");
        }
        Object relationId = arr[0];
        Object specialId = arr[1];
        Object thorBizCode = arr[2];
        Object pid = arr[3];
        Object appKey = arr[4];
        Object appSecret = arr[5];
        TbkDgVegasSendStatusRequest req = new TbkDgVegasSendStatusRequest();
        if (StringUtils.isNotBlank((String)relationId)) {
            req.setRelationId((String)relationId);
        }
        if (StringUtils.isNotBlank((String)specialId)) {
            req.setSpecialId((String)specialId);
        }
        if (StringUtils.isNotBlank((String)thorBizCode)) {
            req.setThorBizCode((String)thorBizCode);
        }
        if (StringUtils.isNotBlank((String)pid)) {
            req.setPid((String)pid);
        }
        String oaidMd5 = request.getOaid_md5();
        if (StringUtils.isBlank((String)req.getDeviceValue()) && StringUtils.isNotBlank((String)oaidMd5)) {
            req.setDeviceValue(oaidMd5);
            req.setDeviceType("OAID");
        }
        String imeiMd5 = request.getImei_md5();
        if (StringUtils.isBlank((String)req.getDeviceValue()) && StringUtils.isNotBlank((String)imeiMd5)) {
            req.setDeviceValue(imeiMd5);
            req.setDeviceType("IMEI");
        }
        String idfaMd5 = request.getIdfa_md5();
        if (StringUtils.isBlank((String)req.getDeviceValue()) && StringUtils.isNotBlank((String)idfaMd5)) {
            req.setDeviceValue(idfaMd5);
            req.setDeviceType("IDFA");
        }
        try {
            boolean isTarget;
            TaobaoClient client = this.getClient((String)appKey, (String)appSecret);
            TbkDgVegasSendStatusResponse response = (TbkDgVegasSendStatusResponse)client.execute((TaobaoRequest)req);
            TbkDgVegasSendStatusResponse.Data data = response.getData();
            if (log.isDebugEnabled()) {
                log.debug("response: {}", (Object)JsonHelper.convert((Object)response));
            }
            if ((isTarget = Optional.ofNullable(data).map(data1 -> {
                List list = Optional.ofNullable(data1.getResultList()).orElse(new ArrayList());
                return list.stream().anyMatch(mapData -> StringUtils.equals((String)"1", (String)mapData.getIsNewUser()));
            }).orElse(false).booleanValue()) && Objects.nonNull(feedback)) {
                feedback.accept(Maps.newHashMap());
            }
            return isTarget;
        }
        catch (Exception e) {
            throw new RtaRequestException(e);
        }
    }
}

