/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.tbflg;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.tbflg.TbflgRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

public class TbflgRtbClient
extends AbstractHttpClientRtaClient {
    public TbflgRtbClient(TbflgRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = request.getParam();
        String[] strings = StringUtils.split((String)param, (String)"|");
        if (strings.length < 2) {
            throw new RtaRequestException("param");
        }
        String appId = strings[0];
        String appSecret = strings[1];
        HashMap query = Maps.newHashMap();
        query.put("method", "rta.check.delivery.ask");
        query.put("appId", appId);
        query.put("appSecret", appSecret);
        if (StringUtils.isNotBlank((String)request.getOaid_md5())) {
            query.put("deviceId", request.getOaid_md5());
            query.put("deviceType", "OAID");
        } else if (StringUtils.isNotBlank((String)request.getIdfa_md5())) {
            query.put("deviceId", request.getIdfa_md5());
            query.put("deviceType", "IDFA");
        } else if (StringUtils.isNotBlank((String)request.getImei_md5())) {
            query.put("deviceId", request.getImei_md5());
            query.put("deviceType", "IMEI");
        } else {
            return null;
        }
        try {
            query.put("sign", this.sign(query, appSecret));
        }
        catch (IOException e) {
            throw new RtaRequestException(e);
        }
        HttpPost post = new HttpPost(this.getProperties().getUrl());
        post.setEntity((HttpEntity)new ByteArrayEntity(JsonHelper.convert2bytes((Object)query)));
        post.setHeader("Content-Type", "application/json;charset=UTF-8");
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return ((Res)JsonHelper.convert((String)json, Res.class)).isTarget();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Tbflg;
    }

    private String sign(Map<String, String> params, String secret) throws IOException {
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        for (Object key : keys) {
            String value = params.get(key);
            if (!StringUtils.isNotBlank((String)key) || !StringUtils.isNotBlank((String)value)) continue;
            query.append((String)key).append(value);
        }
        byte[] bytes = this.encryptHMAC(query.toString(), secret);
        return this.byte2hex(bytes);
    }

    private byte[] encryptHMAC(String data, String secret) throws IOException {
        byte[] bytes;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacMD5");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    private String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static class Res {
        private String rtnFlag;
        private String rtnMsg;
        private boolean result;

        public boolean isTarget() {
            return StringUtils.equals((String)"9999", (String)this.rtnFlag) && this.result;
        }

        public String getRtnFlag() {
            return this.rtnFlag;
        }

        public String getRtnMsg() {
            return this.rtnMsg;
        }

        public boolean isResult() {
            return this.result;
        }

        public void setRtnFlag(String rtnFlag) {
            this.rtnFlag = rtnFlag;
        }

        public void setRtnMsg(String rtnMsg) {
            this.rtnMsg = rtnMsg;
        }

        public void setResult(boolean result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Res)) {
                return false;
            }
            Res other = (Res)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isResult() != other.isResult()) {
                return false;
            }
            String this$rtnFlag = this.getRtnFlag();
            String other$rtnFlag = other.getRtnFlag();
            if (this$rtnFlag == null ? other$rtnFlag != null : !this$rtnFlag.equals(other$rtnFlag)) {
                return false;
            }
            String this$rtnMsg = this.getRtnMsg();
            String other$rtnMsg = other.getRtnMsg();
            return !(this$rtnMsg == null ? other$rtnMsg != null : !this$rtnMsg.equals(other$rtnMsg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Res;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isResult() ? 79 : 97);
            String $rtnFlag = this.getRtnFlag();
            result = result * 59 + ($rtnFlag == null ? 43 : $rtnFlag.hashCode());
            String $rtnMsg = this.getRtnMsg();
            result = result * 59 + ($rtnMsg == null ? 43 : $rtnMsg.hashCode());
            return result;
        }

        public String toString() {
            return "TbflgRtbClient.Res(rtnFlag=" + this.getRtnFlag() + ", rtnMsg=" + this.getRtnMsg() + ", result=" + this.isResult() + ")";
        }
    }
}

