/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.the_aurora_tmall;

import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.the_aurora_tmall.TheAuroraTmallRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

public class TheAuroraTmallClient
extends AbstractHttpClientRtaClient {
    private static final String OAID = "545";
    private static final String IMEI = "546";
    private static final String IDFA = "547";
    private static final String UN_MD5 = "0";
    private static final String MD5 = "1";
    private static final String ANDROID = "Android";
    private static final String IOS = "iOS";
    private final TheAuroraTmallRtaProperties properties;

    public TheAuroraTmallClient(TheAuroraTmallRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String[] arr;
        String param = request.getParam();
        if (StringUtils.isBlank((String)param)) {
            throw new RtaRequestException("The param cannot be empty");
        }
        String appId = null;
        ArrayList devices = null;
        String encryption = UN_MD5;
        if ("android".equals(request.getOs())) {
            appId = OAID;
            if (StringUtils.isNotBlank((String)request.getOaid())) {
                devices = Lists.newArrayList((Object[])new String[]{request.getOaid()});
            } else if (StringUtils.isNotBlank((String)request.getOaid_md5())) {
                devices = Lists.newArrayList((Object[])new String[]{request.getOaid_md5()});
                encryption = MD5;
            }
            if (CollectionUtils.isEmpty(devices)) {
                appId = IMEI;
                if (StringUtils.isNotBlank((String)request.getImei())) {
                    devices = Lists.newArrayList((Object[])new String[]{request.getImei()});
                } else if (StringUtils.isNotBlank((String)request.getImei_md5())) {
                    devices = Lists.newArrayList((Object[])new String[]{request.getImei_md5()});
                    encryption = MD5;
                }
            }
        } else {
            appId = IDFA;
            if (StringUtils.isNotBlank((String)request.getIdfa())) {
                devices = Lists.newArrayList((Object[])new String[]{request.getIdfa()});
            } else if (StringUtils.isNotBlank((String)request.getIdfa_md5())) {
                devices = Lists.newArrayList((Object[])new String[]{request.getIdfa_md5()});
                encryption = MD5;
            }
        }
        String os_type = ANDROID;
        if ("ios".equals(request.getOs())) {
            os_type = IOS;
        }
        if ((arr = StringUtils.splitPreserveAllTokens((String)param, (String)"|")).length < 2) {
            throw new RtaRequestException("param must be {api_key}|{api_secret}");
        }
        String authorization = null;
        try {
            authorization = Base64.getEncoder().encodeToString((arr[0] + ":" + arr[1]).getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RtaRequestException("authorization convert exceptions");
        }
        HttpPost post = new HttpPost(this.getProperties().getUrl());
        post.addHeader("Content-Type", "application/json");
        post.addHeader("authorization", "Basic " + authorization);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("app_id", appId);
        map.put("os_type", os_type);
        map.put("devices", devices);
        map.put("encryption", encryption);
        post.setEntity((HttpEntity)new ByteArrayEntity(JsonHelper.convert2bytes(map)));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        JSONObject response = JSONObject.parseObject((String)json);
        if (response.getInteger("code") != 0) {
            return false;
        }
        return !response.getJSONObject("data").getJSONArray("device").isEmpty();
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Tmall;
    }
}

