/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.uc;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.uc.UcParam;
import com.bxm.pangu.rta.common.uc.UcRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UcRtaClient
extends AbstractHttpClientRtaClient {
    private static final Logger log = LoggerFactory.getLogger(UcRtaClient.class);

    public UcRtaClient(UcRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = Optional.ofNullable(request.getParam()).orElse("quwei|uclink_ac16cc");
        String[] split = StringUtils.split((String)param, (String)"|");
        if (split.length != 2) {
            throw new IllegalArgumentException("param");
        }
        String code = split[0];
        String pd = split[1];
        String url = this.getProperties().getUrl();
        url = StringUtils.replace((String)url, (String)"<code>", (String)code).replace("<pd>", pd);
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        UcParam.UcParamBuilder builder = UcParam.builder();
        if (StringUtils.equals((String)request.getOs(), (String)"android")) {
            builder.os(2);
            if (StringUtils.isNotBlank((String)request.getOaid())) {
                builder.oaid(request.getOaid());
            } else {
                builder.oaid(request.getOaid_md5());
            }
            if (StringUtils.isNotBlank((String)request.getImei())) {
                builder.did(request.getImei());
            } else {
                builder.did(request.getImei_md5());
            }
            if (StringUtils.isNotBlank((String)request.getAndroidid())) {
                builder.dpid(request.getAndroidid());
            } else {
                builder.dpid(request.getAndroidid_md5());
            }
        } else if (StringUtils.equals((String)request.getOs(), (String)"ios")) {
            builder.os(1);
            if (StringUtils.isNotBlank((String)request.getIdfa())) {
                builder.idfa(request.getIdfa());
            } else {
                builder.idfa(request.getIdfa_md5());
            }
        }
        post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert((Object)builder.build()), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return Objects.equals(json, "1");
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Uc;
    }
}

