/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.ucgf;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.ucgf.UcgfRtaProperties;
import com.bxm.pangu.rta.common.ucgf.UcgfRtaRequest;
import com.bxm.pangu.rta.common.ucgf.UcgfRtaResponse;
import com.bxm.warcar.utils.JsonHelper;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UcgfRtaClient
extends AbstractHttpClientRtaClient {
    private static final Logger log = LoggerFactory.getLogger(UcgfRtaClient.class);
    private final UcgfRtaProperties properties;

    public UcgfRtaClient(UcgfRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = request.getParam();
        if (StringUtils.isBlank((String)param)) {
            throw new RtaRequestException("param");
        }
        UcgfRtaRequest ucgfRtaRequest = new UcgfRtaRequest();
        ucgfRtaRequest.setChannel(this.properties.getChannel());
        switch (request.getOs()) {
            case "android": {
                ucgfRtaRequest.setPlatform("ANDROID");
                break;
            }
            case "ios": {
                ucgfRtaRequest.setPlatform("IOS");
                break;
            }
            default: {
                ucgfRtaRequest.setPlatform("UNKNOWN");
            }
        }
        String did = null;
        String didType = null;
        String imei = request.getImei();
        if (StringUtils.isNotBlank((String)imei)) {
            did = imei;
            didType = "IMEI";
        } else if (StringUtils.isNotBlank((String)request.getImei_md5())) {
            did = request.getImei_md5();
            didType = "IMEI_MD5";
        } else if (StringUtils.isNotBlank((String)request.getOaid())) {
            did = request.getOaid();
            didType = "OAID";
        } else if (StringUtils.isNotBlank((String)request.getOaid_md5())) {
            did = request.getOaid_md5();
            didType = "OAID_MD5";
        } else if (StringUtils.isNotBlank((String)request.getAndroidid())) {
            did = request.getAndroidid();
            didType = "ANDROID_ID";
        } else if (StringUtils.isNotBlank((String)request.getAndroidid_md5())) {
            did = request.getAndroidid_md5();
            didType = "ANDROID_ID_MD5";
        } else if (StringUtils.isNotBlank((String)request.getIdfa())) {
            did = request.getIdfa();
            didType = "IDFA";
        } else if (StringUtils.isNotBlank((String)request.getIdfa_md5())) {
            did = request.getIdfa_md5();
            didType = "IDFA_MD5";
        }
        if (StringUtils.isBlank((String)did)) {
            throw new RtaRequestException("did");
        }
        ucgfRtaRequest.setDid(did);
        ucgfRtaRequest.setDidType(didType);
        String url = this.properties.getUrl().replaceAll("<channel>", this.properties.getChannel());
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(JsonHelper.convert((Object)ucgfRtaRequest), StandardCharsets.UTF_8));
        return httpPost;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        UcgfRtaResponse convert = (UcgfRtaResponse)JsonHelper.convert((String)json, UcgfRtaResponse.class);
        Integer statusCode = convert.getStatus_code();
        List<Long> ucAcIds = convert.getAcIds();
        if (statusCode != null && statusCode == 0 && CollectionUtils.isNotEmpty(ucAcIds)) {
            String param = request.getParam();
            List bxmAcIds = Arrays.stream(param.split("\\|")).map(Long::valueOf).collect(Collectors.toList());
            ucAcIds.retainAll(bxmAcIds);
            return !ucAcIds.isEmpty();
        }
        return false;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Ucgf;
    }
}

