package com.bxm.pangu.rta.common.getui;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @author allen
 * @date 2021-12-20
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class GetuiRequest implements Serializable {
    private static final long serialVersionUID = 4736968233351613018L;

    private String requestId;
    private Device device;
    private List<Condition> queryConditions;

    @Data
    @Accessors(chain = true)
    public static class Device {
        private String imei;
        private String imeiMd5;
        private String oaid;
        private String oaidMd5;
        private String idfa;
        private String idfaMd5;
        private String androidId;
        private String androidIdMd5;
    }

    @Data
    @Accessors(chain = true)
    public static class Condition {
        private int adsType;
        private int targetType;
    }
}
