package com.bxm.pangu.rta.common.qihang;

import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.qihang.enums.CarrierEnum;
import com.bxm.pangu.rta.common.qihang.enums.ConnectionTypeEnum;
import com.bxm.pangu.rta.common.qihang.enums.DeviceTypeEnum;
import com.bxm.pangu.rta.common.qihang.proto.SurgeBidding;
import com.bxm.pangu.rta.common.qihang.request.*;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Random;

/**
 * @author zhangdong
 * @date 2022/10/13
 */
public class QiHangRequestBuilder {

    public static SurgeBidding.BidRequest buildRequest(BidRequest request) {
        String ext = request.getExt();
        Ext convert = JsonHelper.convert(ext, Ext.class);
        SurgeBidding.BidRequest.Builder builder = SurgeBidding.BidRequest.newBuilder();
        builder.setId(request.getBidid());
        builder.setApiVersion("1.0.0");
        if (request.getTest() != null) {
            builder.setTest(0);
        }
        SurgeBidding.BidRequest.Device device = buildDevice(JsonHelper.convert(convert.getDevice(), Device.class));
        if (device != null) {
            builder.setDevice(device);
        }
        SurgeBidding.BidRequest.App app = buildApp(request.getApp());
        if (app != null) {
            builder.setApp(app);
        }
        List<Impression> impressions = JSONObject.parseArray(convert.getImps(), Impression.class);
        if (CollectionUtils.isEmpty(impressions)) {
            return builder.build();
        }
        List<SurgeBidding.BidRequest.Imp> imps = Lists.newArrayList();
        for (Impression impression : impressions) {
            SurgeBidding.BidRequest.Imp imp = buildImp(impression);
            if (imp != null) {
                imps.add(imp);
            }
        }
        builder.addAllImp(imps);
        builder.setSspTime(System.currentTimeMillis());
        return builder.build();
    }

    public static SurgeBidding.BidRequest.Device buildDevice(Device device) {
        if (device == null) {
            return null;
        }
        return SurgeBidding.BidRequest.Device.newBuilder()
                .setUa(getValueOrEmpty(device.getUa()))
                .setIp(getValueOrEmpty(device.getIp()))
                .setDeviceType(DeviceTypeEnum.toRequestDeviceType(device.getDevice_type()))
                .setMake(device.getMake() == null ? device.getBrand() == null ? "" : device.getBrand() : device.getMake())
                .setModel(getValueOrEmpty(device.getModel()))
                .setIdfa(getValueOrEmpty(device.getIdfa()))
                .setIdfaMd5(getValueOrEmpty(device.getIdfa_md5()))
                .setOaid(getValueOrEmpty(device.getOaid()))
                .setOaidMd5(getValueOrEmpty(device.getOaid_md5()))
                .setImei(getValueOrEmpty(device.getImei()))
                .setImeiMd5(getValueOrEmpty(device.getImei_md5()))
                .setOs(device.getOs() == null ? "" : device.getOs().toLowerCase())
                .setOsv(getValueOrEmpty(device.getOsv()))
                .setCarrier(CarrierEnum.toRequestCarrier(device.getCarrier()))
                .setConnectionType(ConnectionTypeEnum.toRequestConnectionType(device.getConnection_type()))
                .setAndroidId(getValueOrEmpty(device.getDpid()))
                .setAndroidIdMd5(getValueOrEmpty(device.getDpid_md5()))
                .setMac(getValueOrEmpty(device.getMac()))
                .setMacMd5(getValueOrEmpty(device.getMac_md5()))
                .build();

    }

    private static String getValueOrEmpty(String data) {
        return data == null ? "" : data;
    }

    public static SurgeBidding.BidRequest.Imp buildImp(Impression impression) {
        if (impression == null) {
            return null;
        }
        SurgeBidding.BidRequest.Imp.Builder builder = SurgeBidding.BidRequest.Imp.newBuilder();
        builder.setId(getValueOrEmpty(impression.getId()));
        builder.setTagId("bxm_9_1_gd");
        builder.setSubTagId("bxm_9_1_gd");
        //设置类型
//        Integer adType = ImpTypeEnum.toRequestImpTypeByImpType(impression.getImp_type());
//        if (adType == null) {
//            adType = ImpTypeEnum.toRequestImpTypeByType(impression.getType());
//        }
        builder.setAdType(9);
        builder.setBidType(0);
        builder.setBidFloor(0);
        //设置素材请求信息
        SurgeBidding.BidRequest.Imp.Asset asset = buildAsset(impression);
        if (asset != null) {
            builder.addAsset(asset);
        }
        return builder.build();
    }


    public static SurgeBidding.BidRequest.Imp.Asset buildAsset(Impression impression) {
        if (impression.getA_native() == null || StringUtils.isEmpty(impression.getA_native().getTemplate())) {
            return null;
        }
        SurgeBidding.BidRequest.Imp.Asset.Builder builder = SurgeBidding.BidRequest.Imp.Asset.newBuilder();
        builder.setTemplateId("bxm_jl2");
        if (impression.getH() != null) {
            builder.setHeight(impression.getH());
        }
        if (impression.getW() != null) {
            builder.setWidth(impression.getW());
        }
        return builder.build();
    }

    public static SurgeBidding.BidRequest.App buildApp(App app) {
        if (app == null) {
            return null;
        }
        SurgeBidding.BidRequest.App.Builder builder = SurgeBidding.BidRequest.App.newBuilder();
        if (app.getName() != null) {
            builder.setName(app.getName());
        }
        if (app.getBundle() != null) {
            builder.setBundle("com.kuaishou.nebula");
        }
        if (app.getVer() != null) {
            builder.setVerion(app.getVer());
        }

        return builder.build();
    }

}
