package com.bxm.pangu.rta.common.qihang.enums;

import lombok.Getter;

/**
 * @author zhangdong
 * @date 2022/10/13
 */
@Getter
public enum ConnectionTypeEnum {

    /**
     * 未知
     */
    UNKNOWN(0, "未知"),
    ETHERNET(1, "以太网"),
    WIFI(2, "WIFI"),
    MOBILE_UNKNOWN(3, "移动网络未知"),
    MOBILE_2G(4, "2G网络"),
    MOBILE_3G(5, "3G网络"),
    MOBILE_4G(6, "4G网络"),
    MOBILE_5G(7, "5G网络"),

    ;

    private Integer code;

    private String desc;

    ConnectionTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer toRequestConnectionType(Integer type) {
        AdxConstants.ConnectionType connectionType = AdxConstants.ConnectionType.getType(type);
        switch (connectionType) {
            case WIFI:
                return WIFI.code;
            case ETHERNET:
                return ETHERNET.code;
            case UNKNOW_XG:
                return MOBILE_UNKNOWN.code;
            case _2G:
                return MOBILE_2G.code;
            case _3G:
                return MOBILE_3G.code;
            case _4G:
                return MOBILE_4G.code;
            case _5G:
                return MOBILE_5G.code;
            default:
                return UNKNOWN.code;
        }
    }


}
