package com.bxm.pangu.rta.common;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Protocol;

import java.time.Duration;
import java.util.Set;

/**
 * @author allen
 * @date 2022-02-16
 * @since 1.0
 */
@ConfigurationProperties(prefix = "rta.caching")
public class CachingRedisProperties extends JedisPoolConfig {

    private String host = Protocol.DEFAULT_HOST;
    private String password;
    private int port = Protocol.DEFAULT_PORT;
    private int timeout = Protocol.DEFAULT_TIMEOUT;
    private int database = Protocol.DEFAULT_DATABASE;

    /**
     * 开启缓存的 RtaClient 实例类名 (e.g. com.bxm.pangu.rta.common.testing.TestingRtaClient)。
     */
    private Set<String> enableRtaClient = Sets.newHashSet();

    /**
     * 钉钉推送地址
     */
    private String dingTalkUrl = "https://oapi.dingtalk.com/robot/send?access_token=286c319d5372a26356c61106c129286a5535269896273bc0857d57d576c7ba62";

    /**
     * 如果命中RTA缓存时间，默认：1s
     * 如果为空则永久缓存
     */
    private Duration hitExpireTime = Duration.ofSeconds(1);
    /**
     * 如果未命中RTA缓存时间，默认：1s
     * 如果为空则永久缓存
     */
    private Duration unhitExpireTime = Duration.ofSeconds(1);

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getDatabase() {
        return database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public Set<String> getEnableRtaClient() {
        return enableRtaClient;
    }

    public void setEnableRtaClient(Set<String> enableRtaClient) {
        this.enableRtaClient = enableRtaClient;
    }

    public String getDingTalkUrl() {
        return dingTalkUrl;
    }

    public void setDingTalkUrl(String dingTalkUrl) {
        this.dingTalkUrl = dingTalkUrl;
    }

    public Duration getHitExpireTime() {
        return hitExpireTime;
    }

    public void setHitExpireTime(Duration hitExpireTime) {
        this.hitExpireTime = hitExpireTime;
    }

    public Duration getUnhitExpireTime() {
        return unhitExpireTime;
    }

    public void setUnhitExpireTime(Duration unhitExpireTime) {
        this.unhitExpireTime = unhitExpireTime;
    }
}
