package com.bxm.pangu.rta.common.baichuan;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.getui.GetuiRequest;
import com.bxm.pangu.rta.common.getui.GetuiResponse;
import com.bxm.pangu.rta.common.getui.GetuiRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.UUIDHelper;
import com.google.common.collect.Lists;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.springframework.http.MediaType;

import java.nio.charset.StandardCharsets;
import java.util.List;

/**
 * @author tangxiao
 * @date 2022-01-13
 * @since 1.0
 */
public class BaichuanRtaClient extends AbstractHttpClientRtaClient {

    private final BaichuanRtaProperties properties;

    public BaichuanRtaClient(BaichuanRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        HttpPost post = new HttpPost(properties.getUrl());

        post.addHeader("Content-Type", MediaType.APPLICATION_JSON_UTF8_VALUE);

        BaichuanRequest.DeviceMsg deviceMsg = new BaichuanRequest.DeviceMsg()
                .setImei(request.getImei()).setImeiMd5(request.getImei_md5())
                .setOaid(request.getOaid()).setOaidMd5(request.getOaid_md5())
                .setIdfa(request.getIdfa()).setIdfaMd5(request.getIdfa_md5());

        BaichuanRequest bc = new BaichuanRequest()
                .setChannel(properties.getChannel())
                .setDeviceMsgList(Lists.newArrayList(deviceMsg));

        post.setEntity(new StringEntity(JsonHelper.convert(bc), StandardCharsets.UTF_8));

        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        BaichuanResponse response = JsonHelper.convert(json, BaichuanResponse.class);
        if (!response.isRequestOk()) {
            return false;
        }
        List<BaichuanResponse.Data> data = response.getData();
        return CollectionUtils.isNotEmpty(data) && data.get(0).getRtaIdList().contains(request.getParam());
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Baichuan;
    }
}
